% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_elevation_gain}
\alias{get_elevation_gain}
\title{(Cumulative) Elevation gain.}
\usage{
get_elevation_gain(object, smooth = FALSE, cumulative = FALSE,
  vertical_noise = 0)
}
\arguments{
\item{object}{A (univariate) zoo object.}

\item{smooth}{Logical. Should the elevation be smoothed? Default is
\code{TRUE}.}

\item{cumulative}{Logical. Return the cumulative elevation gain
(\code{FALSE}; default) or just the elevation gain?}

\item{vertical_noise}{A scalar. Absolute elevation gains less that
\code{vertical_noise} are set to zero. Default is \code{0}.}
}
\description{
(Cumulative) Elevation gain.
}
\details{
The elevation gain is defined here as the difference in altitude
between two consecutive observations. If \code{cumulative = FALSE}
then the elevation gain is returned, otherwise any elevation loses
(i.e. negative elevation gain) are ignored and the cumulative
elevation gain is returned. If \code{smooth = TRUE} then the
elevation gain will be smoothed using a spline smoother before
either returning it or computing cumulative elevation gains.
}
