% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{compute_breaks}
\alias{compute_breaks}
\title{Compute a grid of breakpoints per variable from a \code{\link{trackeRdata}} object.}
\usage{
compute_breaks(object, a = 1e-04, n_breaks = 9, limits = NULL,
  what = c("speed", "heart_rate"))
}
\arguments{
\item{object}{A \code{\link{trackeRdata}} object.}

\item{a}{The levels at which quantiles will be computed are
\code{a} and \code{1 - a}. Default is \code{a = 0.0001}.}

\item{n_breaks}{A scalar determining the number of breakpoints to
be computed}

\item{limits}{A list of a vectors, each specifying the lower and
upper limit for each variable to be used when computing the
grid. Default is \code{NULL}, in which case
\code{\link{compute_limits}} is used.}

\item{what}{The variables for which a grid of breakpoints should be
computed. Defaults to \code{c("speed", "heart_rate")}.}
}
\value{
A named list with names as in \code{what}, with elements the grids
of breakpoints per variable.
}
\description{
Compute a grid of breakpoints per variable from a \code{\link{trackeRdata}} object.
}
\examples{
data("runs")
compute_breaks(runs, what = c("speed", "heart_rate", "altitude"))
}
