% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeR.R
\docType{package}
\name{trackeR}
\alias{trackeR}
\alias{trackeR-package}
\title{trackeR: Infrastructure for running and cycling data from GPS-enabled tracking devices}
\description{
trackeR provides infrastructure for handling cycling and running
data from GPS-enabled tracking devices. After extraction and appropriate
manipulation of the training or competition attributes, the data are placed into
session-aware data objects with an S3 class trackeRdata. The information in the
resultant data objects can then be visualised, summarised and analysed through
corresponding flexible and extensible methods.
}
\section{Note}{


Core facilities in the trackeR package, including reading functions
(see \code{\link{readX}}), data pre-processing strategies (see
\code{\link{trackeRdata}}), and calculation of concentration and
distribution profiles (see \code{\link{distributionProfile}} and
\code{\link{concentrationProfile}}) are based on un-packaged R code
that was developed by Ioannis Kosmidis for the requirements of the
analyses in Kosmidis & Passfield (2015).
}
\references{
Kosmidis, I., and Passfield, L. (2015). Linking the Performance of
    Endurance Runners to Training and Physiological Effects via Multi-Resolution
    Elastic Net. \emph{ArXiv e-print} arXiv:1506.01388.
}

