% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{missing_xy}
\alias{missing_xy}
\title{Find Missing Locations in a Track Table}
\usage{
missing_xy(x)
}
\arguments{
\item{x}{A \code{\link{track}} table as produced by the \code{\link{track}}
function.}
}
\value{
A data frame/table/tibble with the timestamps and type of missing
 data for each individual track in \code{x}. If no missing data are detected,
 the function returns \code{NULL}.
}
\description{
This function attempts to automatically detect missing location
 data in \code{\link{track}} tables.
}
\examples{
# Create data set with missing coordinates
data(short_tracks)
t_df <- track(x = short_tracks$x, y = short_tracks$y, t = short_tracks$t,
              id = short_tracks$id, proj = "+proj=longlat",
              tz = "Africa/Windhoek", table = "df")
t_df$x[c(10, 100)] <- NA
t_df$y[c(20, 110)] <- NA

# Find missing data
missing <- missing_xy(t_df)

}
\seealso{
\code{\link{track}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
