% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ess.R
\name{calc_ess}
\alias{calc_ess}
\title{Calculates the Effective Sample Size}
\usage{
calc_ess(trace, sample_interval)
}
\arguments{
\item{trace}{the values without burn-in}

\item{sample_interval}{the interval in timesteps between samples}
}
\value{
the effective sample size
}
\description{
Calculates the Effective Sample Size
}
\examples{
filename <- get_tracerer_path("beast2_example_output.log")
estimates <- parse_beast_tracelog_file(filename)
calc_ess(estimates$posterior, sample_interval = 1000)
}
\seealso{
Java code can be found here: \url{https://github.com/CompEvol/beast2/blob/9f040ed0357c4b946ea276a481a4c654ad4fff36/src/beast/core/util/ESS.java#L161} # nolint URLs can be long
}
\author{
The original Java version of the algorithm was from Remco Bouckaert,
  ported to R and adapted by Richèl J.C. Bilderbeek
}
