% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-TxpResult-plot.R
\name{TxpResult-plot}
\alias{TxpResult-plot}
\alias{plot}
\alias{plot,TxpResult,missing-method}
\alias{plot,TxpResult,numeric-method}
\title{Plot TxpResult objects}
\usage{
\S4method{plot}{TxpResult,missing}(
  x,
  fills = NULL,
  showScore = TRUE,
  gp = NULL,
  vp = NULL,
  name = NULL,
  newpage = TRUE,
  ...
)

\S4method{plot}{TxpResult,numeric}(
  x,
  y,
  labels = NULL,
  newpage = TRUE,
  margins = c(4, 0, 1, 1),
  name = NULL,
  gp = NULL,
  vp = NULL,
  ...
)
}
\arguments{
\item{x}{\link{TxpResult} object}

\item{fills}{Vector of colors to fill slices}

\item{showScore}{Logical scalar, overall score printed below the name when
\code{TRUE}}

\item{gp, vp, name}{Passed to \link[grid:grid.frame]{grid::frameGrob} when creating the plotting
area}

\item{newpage}{Logical scalar, \link[grid:grid.newpage]{grid::grid.newpage} called prior to plotting
when \code{TRUE}}

\item{...}{Passed to \link{pieGridGrob} when plotting ToxPi and to pointsGrob
when plotting ranks}

\item{y}{Rank vector, i.e. \code{txpRanks(x)}}

\item{labels}{Integer vector, indices of \code{x} to label in the rank plot}

\item{margins}{Passed to \link[grid:plotViewport]{grid::plotViewport}; only affects the scatterplot
region margins}
}
\value{
No return value; called for side effect (i.e. drawing in current
graphics device.)
}
\description{
Plot \link{TxpResult} objects
}
\details{
It is strongly recommended to use a specific device (e.g., \link[grDevices:png]{grDevices::png},
\link[grDevices:pdf]{grDevices::pdf}) when creating rank plots.
Using a GUI device will likely lead to inaccurate labeling, and any changes
to the device size WILL lead to inaccurate labeling.

The plotting is built on the \link[grid:grid-package]{grid::grid-package}, and can be adjusted or
edited as such.

If the labels are running of the device, the top or bottom margins can be
increased with the \code{margins} parameter.
}
\section{Functions}{
\itemize{
\item \code{plot,TxpResult,missing-method}: Plot ToxPi diagrams

\item \code{plot,TxpResult,numeric-method}: Plot ToxPi ranks
}}

\examples{
## Load example dataset & model; see ?TxpModel for building model objects
data(txp_example_input, package = "toxpiR")
data(txp_example_model, package = "toxpiR")

## Calculate scores for single model; returns TxpResult object
res <- txpCalculateScores(model = txp_example_model, 
                          input = txp_example_input, 
                          id.var = "name")

library(grid)
plot(res)

plot(res, txpRanks(res))
plot(res, txpRanks(res), pch = 16, size = unit(0.75, "char"))

## Will likely make inaccurate labels within a GUI, e.g. RStudio
## use png, pdf, etc. to get accurate labels
\dontrun{
tmpPdf <- tempfile()
pdf(tmpPdf)
plot(res, txpRanks(res), labels = c(10, 4, 2), pch = 16)
dev.off()
}

}
