% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.r
\name{render_anim}
\alias{render_anim}
\title{Render a set of animation frames}
\usage{
render_anim(
  data,
  vars = NULL,
  frames,
  edges = NULL,
  axis_labels = NULL,
  obs_labels = NULL,
  limits = 1,
  position = "center"
)
}
\arguments{
\item{data}{matrix, or data frame containing numeric columns,
should be standardised to have mean 0, sd 1}

\item{vars}{numeric columns of data to be projected, as a vector, eg 1:4}

\item{frames}{array of projection matrices, should be interpolated already}

\item{edges}{to and from of row id's to connect with an line}

\item{axis_labels}{labels of the axes to be displayed}

\item{obs_labels}{labels of the observations to be available for interactive mouseover}

\item{limits}{value setting the lower and upper limits of
projected data, default 1}

\item{position}{position of the axes: center (default),
left of data or off}
}
\value{
list containing indexed projected data, edges, circle and segments for axes
}
\description{
This function takes a set of frames as produced by
save_history(), and creates the projected data and axes
in for format needed to create the animation using plotly.
It will be useful for showing a tour where mouseover can
be used to identify points.
Note that for now this only works for 2D projections.
}
\examples{
data(flea)
flea_std <- apply(flea[,1:6], 2, function(x) (x-mean(x))/sd(x))
t1 <- save_history(flea_std, max=2)
t1i <- tourr::interpolate(t1, 0.1)
p <- render_anim(data=flea_std, frames=t1i)
if (require(ggplot2)) {
  pg <- ggplot() +
    geom_path(data=p$circle, aes(x=c1, y=c2, frame=frame)) +
    geom_segment(data=p$axes, aes(x=x1, y=y1, xend=x2, yend=y2, frame=frame)) +
    geom_text(data=p$axes, aes(x=x2, y=y2, frame=frame, label=axis_labels)) +
    geom_point(data=p$frames, aes(x=P1, y=P2, frame=frame, label=obs_labels)) +
    coord_equal() +
    theme_bw() +
    theme(axis.text=element_blank(),
        axis.title=element_blank(),
        axis.ticks=element_blank(),
        panel.grid=element_blank())
  if (interactive()) {
    require(plotly)
    ggplotly(pg, width=500, height=500) |>
      animation_button(label="Go") |>
      animation_slider(len=0.8, x=0.5, xanchor="center") |>
      animation_opts(easing="linear", transition=0, redraw=FALSE)
  }
}
}
