% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display-trails.r
\name{display_trails}
\alias{display_trails}
\alias{animate_trails}
\title{Display tour path with trails}
\usage{
display_trails(
  center = TRUE,
  axes = "center",
  half_range = NULL,
  col = "black",
  pch = 20,
  cex = 1,
  past = 3,
  ...
)

animate_trails(data, tour_path = grand_tour(), ...)
}
\arguments{
\item{center}{if TRUE, centers projected data to (0,0).  This pins the
center of data cloud and make it easier to focus on the changing shape
rather than position.}

\item{axes}{position of the axes: center, bottomleft or off}

\item{half_range}{half range to use when calculating limits of projected.
If not set, defaults to maximum distance from origin to each row of data.}

\item{col}{color to be plotted.  Defaults to "black"}

\item{pch}{shape of the point to be plotted.  Defaults to 20.}

\item{cex}{magnification of plotting text relative to default. Defaults to 1.}

\item{past}{draw line between current projection and projection \code{past}
steps ago}

\item{...}{other arguments passed on to \code{\link{animate}} and
\code{\link{display_xy}}}

\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator, defaults to 2d grand tour}
}
\description{
Animate a 2D tour path with a point trails
}
\examples{
animate_trails(flea[,1:6], col=flea$species)

}
