% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_fips_and_names.R
\name{convert_fips_to_names}
\alias{convert_fips_to_names}
\title{convert fips codes to names of a geographies}
\usage{
convert_fips_to_names(FIPs, states = NULL, geo_header = "STATE",
  in_states = NULL)
}
\arguments{
\item{FIPs}{string vector of fips code such as c("021", "002")}

\item{states}{string vector of state abbreviations having same length as FIPs}

\item{geo_header}{string, taking values of "STATE", "COUNTY", "PLACE", "COUSUB"
or "CBSA".}

\item{in_states}{which states are these FIPs generated from. Use state abbrevations
or "US" for national. Vector of unique states.}
}
\value{
vector of names corresponding to FIPs and states
}
\description{
convert fips codes to names of a geographies
}
\examples{
aaa <- convert_fips_to_names(c("11", "44"))
# [1] "DC" "RI"

bbb <- convert_fips_to_names(c("001", "013"), states = c("RI", "MA"), geo_header = "COUNTY")
# [1] "Bristol County" "Hampden County"

\dontrun{
# The only purpose of downloading data to temporary directory is to test the
# following examples. Do not do it when you have data in your local computer.
tmp <- tempdir()
url <- "https://s3.amazonaws.com/gl-shared-data/generated_census_data.zip"
download.file(url, paste0(tmp, "/tmp.zip"))
unzip(
    paste0(tmp, "/tmp.zip"),
    exdir = paste0(tmp, "/generated_data")
)
Sys.setenv(PATH_TO_CENSUS = tmp)

convert_fips_to_names(
    FIPs = c("14140", "76030"),
    states = c("RI", "MA"),
    geo_header = "PLACE",
    in_states = c("RI", "MA")
)
# [1] "Central Falls city" "Westfield city"

convert_fips_to_names(
    FIPs = c("39300", "46740"),
    states = c(NA, NA),
    geo_header = "CBSA",
    in_states = "US"
)
# [1] "Providence-New Bedford-Fall River, RI-MA Metro Area" "Valley, AL Micro Area"
}

}
