# lookup_acs5year_2016 =========================================================
#' ACS 5-year 2015 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 22910 rows and 6 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2016"




# lookup_acs5year_2015 =========================================================
#' ACS 5-year 2015 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 22910 rows and 6 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2015"




# lookup_acs1year_2016 =========================================================
#' ACS 1-year 2016 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 31835 rows and 6 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2016"


# lookup_acs1year_2015 =========================================================
#' ACS 1-year 2015 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 31751 rows and 6 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0165"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2015"


# lookup_acs1year_2014 =========================================================
#' ACS 1-year 2014 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 31711 rows and 6 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0165"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2014"



# dict_acs_table ============================================================
#' Complete list of ACS tables
#'
#' @description This dataset contains all tables in 1-year and 5-year survey.
#' Note that 5-year survey in 2014 and 2015 has the identical tables.
#'
#'
#' @docType data
#'
#'
#' @format A data.table with 1324 rows and 6 variables:
#' \describe{
#'   \item{table_number}{table number such as "C27013"}
#'   \item{table_name}{description of the table}
#'   \item{acs5_2015}{table available in 2015 ACS 5-year survey}
#'   \item{acs1_2016}{table available in 2016 ACS 1-year survey}
#'   \item{acs1_2015}{table available in 2015 ACS 1-year survey}
#'   \item{acs1_2014}{table available in 2014 ACS 1-year survey}
#' }

#'
#' @keywords datasets
#'
#' @source generated from lookup datasets.
#'
#'
"dict_acs_table"


# dict_acs_geoheaders ===========================================
#' List of geographic headers used in American Community Survey
#'
#' @description  This dataset has the complete list of geographic header
#' references and their discription used in ACS 1-year and 5-year summary file.
#' Search the dataset with function \code{\link{search_geoheaders}}.
#'
#' @docType data
#'
#'
#' @format A data.table with 53 rows and 4 variables
#' \describe{
#'   \item{reference}{reference of the geoheader}
#'   \item{field}{description of the geoheader}
#'   \item{start}{starting position of the geoheader in geography file}
#'   \item{end}{ending position of the geoheader in geography file}
#' }
#'
#' @keywords datasets
#'
#' @source 2016 ACS Summary File
#' \href{https://www2.census.gov/programs-surveys/acs/summary_file/2016/documentation/tech_docs/2016_SummaryFile_Tech_Doc.pdf}{technical documentation},
#' page 10 - 11.
#'
#'
"dict_acs_geoheader"

# dict_acs_summarylevel =====================================================
#' Summary levels available in American Community Survey
#'
#' @description  This data contains summary levels and codes used in 1-year and
#' 5-year survey. Search with function \code{\link{search_summarylevels}}.
#'
#' @docType data
#'
#'
#' @format A data.table with 87 rows and 6 variables
#' \describe{
#'   \item{code}{code of summary level}
#'   \item{summary_level}{description of summary level}
#'   \item{state_acs1}{wheather a summary level available in 1-year survey state files}
#'   \item{US_acs1}{wheather a summary level available in 1-year survey national files}
#'   \item{state_acs5}{wheather a summary level available in 5-year survey state files}
#'   \item{US_acs5}{wheather a summary level available in 5-year survey national files}
#' }
#'
#' @keywords datasets
#'
#' @source generated from lookup datasets
#'

"dict_acs_summarylevel"


# dict_acs_geocomponent =====================================================
#' List of geographic components used in American Community Survey
#'
#' @description This dataset contains the geographic components and codes used in
#' 1-year and 5-year surveys. Search geographic components
#' with function \code{\link{search_geoheaders}}.
#'
#' @docType data
#'
#'
#' @format A data.table with 19 rows and 6 variables:
#' \describe{
#'   \item{code}{code for the geocomponent, such as "01" and "M3"}
#'   \item{geo_component}{description of the geographic component}
#'   \item{state_acs1}{wheather a geocomponent available in 1-year survey state files}
#'   \item{US_acs1}{wheather a geocomponent available in 1-year survey national files}
#'   \item{state_acs5}{wheather a geocomponent available in 5-year survey state files}
#'   \item{US_acs5}{wheather a geocomponent available in 5-year survey national files}
#' }
#'
#' @keywords datasets
#'
#' @source  generated from lookup files
#'
#'
"dict_acs_geocomponent"

