% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_phaser}
\alias{functional_phaser}
\title{Phasing Effect (functional)}
\usage{
functional_phaser(
  waveform,
  sample_rate,
  gain_in = 0.4,
  gain_out = 0.74,
  delay_ms = 3,
  decay = 0.4,
  mod_speed = 0.5,
  sinusoidal = TRUE
)
}
\arguments{
\item{waveform}{(Tensor): audio waveform of dimension of \verb{(..., time)}}

\item{sample_rate}{(int): sampling rate of the waveform, e.g. 44100 (Hz)}

\item{gain_in}{(float): desired input gain at the boost (or attenuation) in dB.
Allowed range of values are 0 to 1}

\item{gain_out}{(float): desired output gain at the boost (or attenuation) in dB.
Allowed range of values are 0 to 1e9}

\item{delay_ms}{(float): desired delay in milli seconds.
Allowed range of values are 0 to 5.0}

\item{decay}{(float):  desired decay relative to gain-in. Allowed range of values are 0 to 0.99}

\item{mod_speed}{(float):  modulation speed in Hz.
Allowed range of values are 0.1 to 2}

\item{sinusoidal}{(bool):  If \code{TRUE}, uses sinusoidal modulation (preferable for multiple instruments).
If \code{FALSE}, uses triangular modulation  (gives single instruments a sharper phasing effect)
(Default: \code{TRUE})}
}
\value{
\code{tensor}: Waveform of dimension of \verb{(..., time)}
}
\description{
Apply a phasing effect to the audio. Similar to SoX implementation.
}
\references{
\itemize{
\item \url{https://sox.sourceforge.net/sox.html}
}
}
