% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_symeig}
\alias{torch_symeig}
\title{Symeig}
\usage{
torch_symeig(self, eigenvectors = FALSE, upper = TRUE)
}
\arguments{
\item{self}{(Tensor) the input tensor of size \eqn{(*, n, n)} where \code{*} is zero or more                    batch dimensions consisting of symmetric matrices.}

\item{eigenvectors}{(boolean, optional) controls whether eigenvectors have to be computed}

\item{upper}{(boolean, optional) controls whether to consider upper-triangular or lower-triangular region}
}
\description{
Symeig
}
\note{
The eigenvalues are returned in ascending order. If \code{input} is a batch of matrices,
then the eigenvalues of each matrix in the batch is returned in ascending order.

Irrespective of the original strides, the returned matrix \code{V} will
be transposed, i.e. with strides \verb{V.contiguous().transpose(-1, -2).stride()}.

Extra care needs to be taken when backward through outputs. Such
operation is really only stable when all eigenvalues are distinct.
Otherwise, \code{NaN} can appear as the gradients are not properly defined.
}
\section{symeig(input, eigenvectors=False, upper=TRUE) -> (Tensor, Tensor) }{


This function returns eigenvalues and eigenvectors
of a real symmetric matrix \code{input} or a batch of real symmetric matrices,
represented by a namedtuple (eigenvalues, eigenvectors).

This function calculates all eigenvalues (and vectors) of \code{input}
such that \eqn{\mbox{input} = V \mbox{diag}(e) V^T}.

The boolean argument \code{eigenvectors} defines computation of
both eigenvectors and eigenvalues or eigenvalues only.

If it is \code{FALSE}, only eigenvalues are computed. If it is \code{TRUE},
both eigenvalues and eigenvectors are computed.

Since the input matrix \code{input} is supposed to be symmetric,
only the upper triangular portion is used by default.

If \code{upper} is \code{FALSE}, then lower triangular portion is used.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(5, 5))
a = a + a$t()  # To make a symmetric
a
o = torch_symeig(a, eigenvectors=TRUE)
e = o[[1]]
v = o[[2]]
e
v
a_big = torch_randn(c(5, 2, 2))
a_big = a_big + a_big$transpose(-2, -1)  # To make a_big symmetric
o = a_big$symeig(eigenvectors=TRUE)
e = o[[1]]
v = o[[2]]
torch_allclose(torch_matmul(v, torch_matmul(e$diag_embed(), v$transpose(-2, -1))), a_big)
}
}
