% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-init.R
\name{nn_init_xavier_normal_}
\alias{nn_init_xavier_normal_}
\title{Xavier normal initialization}
\usage{
nn_init_xavier_normal_(tensor, gain = 1)
}
\arguments{
\item{tensor}{an n-dimensional \code{Tensor}}

\item{gain}{an optional scaling factor}
}
\description{
Fills the input \code{Tensor} with values according to the method
described in \verb{Understanding the difficulty of training deep feedforward neural networks} - Glorot, X. & Bengio, Y. (2010), using a normal
distribution.
}
\examples{
if (torch_is_installed()) {
w <- torch_empty(3, 5)
nn_init_xavier_normal_(w)

}
}
