% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{nn_module_list}
\alias{nn_module_list}
\title{Holds submodules in a list.}
\usage{
nn_module_list(modules = list())
}
\arguments{
\item{modules}{a list of modules to add}
}
\description{
\link{nn_module_list} can be indexed like a regular R list, but
modules it contains are properly registered, and will be visible by all
\code{nn_module} methods.
}
\examples{
if (torch_is_installed()) {

my_module <- nn_module(
  initialize = function() {
    self$linears <- nn_module_list(lapply(1:10, function(x) nn_linear(10, 10)))
  },
  forward = function(x) {
    for (i in 1:length(self$linears)) {
      x <- self$linears[[i]](x)
    }
    x
  }
)
}
}
\seealso{
\code{\link[=nn_module_dict]{nn_module_dict()}}
}
