% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topsa.R
\name{topsa}
\alias{topsa}
\title{Topological Sensitivity Analysis}
\usage{
topsa(Ydat, Xdat, threshold.radius = rep(0.05, ncol(Xdat)), method = "Alpha")
}
\arguments{
\item{Ydat}{numeric vector of responses in a model.}

\item{Xdat}{numeric matrix or data.frame of covariables.}

\item{threshold.radius}{percent of radius or sizes of triangles to keep.
the homology complex. Defaults to `0.05`.
complex}

\item{method}{type of method to build the homology complex. Two choices are
accepted: \code{Alpha} o \code{VR} (Vietoris-Rips).}
}
\value{
A list of class \code{topsa} with the following elements:

\describe{
\item{\strong{call}}{The function call.}
\item{\strong{Xdat}}{\code{X} input.}
\item{\strong{Ydat}}{\code{Y} output.}
\item{\strong{dimension}}{dimension to estimate the homology order.}
\item{\strong{threshold}}{cutoff level for the radius or area.}
\item{\strong{results}}{A list for each variable with:
\describe{
\item{\strong{threshold}}{threshold used to limit the radius or area.}
\item{\strong{Manifold_Area}}{geometrical area of the estimated manifold.}
\item{\strong{Box.Area}}{geometrical area of the estimated manifold.}
\item{\strong{Geometric.R2}}{geometric correlation between each
\code{x} and \code{y}.}
\item{\strong{Geometric.Sensitivity}}{symmetric sensitivity
index of each estimated manifold.}
\item{\strong{manifold_plot}}{a \code{sf}
object with the estimated manifold.}
} } }
}
\description{
Topological Sensitivity Analysis
}
\examples{

ishigami.fun <- function(X) {
A <- 7
B <- 0.1
sin(X[, 1]) + A * sin(X[, 2])^2 + B * X[, 3]^4 * sin(X[, 1])
}
X <- matrix(runif(3*50, -pi, pi), ncol = 3)
Y <- ishigami.fun(X)
estimation <- topsa(Ydat = Y, Xdat = X,method = "Alpha")
}
