% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{process_antigenic_data}
\alias{process_antigenic_data}
\title{Process Raw Antigenic Assay Data}
\usage{
process_antigenic_data(
  file_path,
  antigen_col,
  serum_col,
  value_col,
  is_titer = TRUE,
  metadata_cols = NULL,
  id_prefix = FALSE,
  base = NULL,
  scale_factor = 10
)
}
\arguments{
\item{file_path}{Character. Path to CSV file containing raw data.}

\item{antigen_col}{Character. Name of column containing virus/antigen identifiers.}

\item{serum_col}{Character. Name of column containing serum/antibody identifiers.}

\item{value_col}{Character. Name of column containing measurements (titers or distances).}

\item{is_titer}{Logical. Whether values are titers (TRUE) or distances like IC50 (FALSE).}

\item{metadata_cols}{Character vector. Names of additional columns to preserve.}

\item{id_prefix}{Logical. Whether to prefix IDs with V/ and S/ (default: TRUE).}

\item{base}{Numeric. Base for logarithm transformation (default: 2 for titers, e for IC50).}

\item{scale_factor}{Numeric. Scale factor for titers (default: 10).}
}
\value{
A list containing two elements:
\item{long}{A \code{data.frame} in long format with standardized columns, including the original identifiers, processed values, and calculated distances. Any specified metadata is also included.}
\item{matrix}{A numeric \code{matrix} representing the processed symmetric distance matrix, with antigens and sera on columns and rows.}
}
\description{
Processes raw antigenic assay data from CSV files into standardized long and matrix
formats. Handles both titer data (which needs conversion to distances) and direct
distance measurements like IC50. Preserves threshold indicators (<, >) and handles
repeated measurements by averaging.
}
\details{
The function handles these key steps:
\enumerate{
\item Reads and validates input data
\item Transforms values to log scale
\item Converts titers to distances if needed
\item Averages repeated measurements
\item Creates standardized long format
\item Creates distance matrix
\item Preserves metadata and threshold indicators
\item Preserves virusYear and serumYear columns if present
}

Input requirements and constraints:
\itemize{
\item CSV file must contain required columns
\item Column names must match specified parameters in the function input
\item Values can include threshold indicators (< or >)
\item Metadata columns must exist if specified
\item Allowed Year-related column names are "virusYear" and "serumYear"
}
}
\examples{
# Locate the example data file included in the package
file_path <- system.file("extdata", "example_titer_data.csv", package = "topolow")

# Check if the file exists before running the example
if (file.exists(file_path)) {
  # Process the example titer data
  results <- process_antigenic_data(
    file_path,
    antigen_col = "virusStrain",
    serum_col = "serumStrain", 
    value_col = "titer",
    is_titer = TRUE,
    metadata_cols = c("cluster", "color")
  )

  # View the long format data
  print(results$long)
  # View the distance matrix
  print(results$matrix)
}
}
