% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_coherence.R
\name{topic_coherence}
\alias{topic_coherence}
\title{Calculate the topic coherence for each topic in a topic model}
\usage{
topic_coherence(topic_model, dtm_data, top_n_tokens = 10,
  smoothing_beta = 1)
}
\arguments{
\item{topic_model}{a fitted topic model object from one of the following:
\code{\link[topicmodels]{tm-class}}}

\item{dtm_data}{a document-term matrix of token counts coercible to \code{simple_triplet_matrix}}

\item{top_n_tokens}{an integer indicating the number of top words to consider,
the default is 10}

\item{smoothing_beta}{a numeric indicating the value to use to smooth the document frequencies
in order avoid log zero issues, the default is 1}
}
\value{
A vector of topic coherence scores with length equal to the number of topics in the fitted model
}
\description{
Using the the N highest probability tokens for each topic, calculate
the topic coherence for each topic
}
\examples{

# Using the example from the LDA function
library(topicmodels)
data("AssociatedPress", package = "topicmodels")
lda <- LDA(AssociatedPress[1:20,], control = list(alpha = 0.1), k = 2)
topic_coherence(lda, AssociatedPress[1:20,])
}
\references{
{
  Mimno, D., Wallach, H. M., Talley, E., Leenders, M., & McCallum, A. (2011, July).
  "Optimizing semantic coherence in topic models." In Proceedings of the Conference on
  Empirical Methods in Natural Language Processing (pp. 262-272). Association for
  Computational Linguistics. Chicago

  McCallum, Andrew Kachites.  "MALLET: A Machine Learning for Language Toolkit."
  \url{http://mallet.cs.umass.edu.} 2002.
}
}
\seealso{
\code{\link[stm]{semanticCoherence}}
}
