% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateGraph.R
\name{validateGraph}
\alias{validateGraph}
\title{Validate graph data in Aster for consistency.}
\usage{
validateGraph(channel, graph, weight = NULL,
  vertexWhere = graph$vertexWhere, edgeWhere = graph$edgeWhere,
  allTables = NULL, test = FALSE)
}
\arguments{
\item{channel}{connection object as returned by \code{\link{odbcConnect}}}

\item{graph}{an object of class \code{'toagraph'} referencing graph 
tables in Aster database.}

\item{weight}{logical or character: if logical then \code{TRUE} indicates using \code{'weight'} edge
attribute, otherwise no weight used. If character then use as a name for the edge weight attribute. 
The edge weight may apply with types \code{'clustering', 'shortestpath'} and centrality measures.}

\item{vertexWhere}{SQL WHERE clause limiting data from the vertex table. This value when not null
overrides corresponding value \code{vertexWhere} from \code{graph} (use SQL as if in WHERE clause but 
omit keyword WHERE).}

\item{edgeWhere}{SQL WHERE clause limiting data from the edge table. This value when not null
overrides corresponding value \code{edgeWhere} from \code{graph} (use SQL as if in WHERE clause but 
omit keyword WHERE).}

\item{allTables}{pre-built information about existing tables.}

\item{test}{logical: if TRUE show what would be done, only (similar to parameter \code{test} in \pkg{RODBC} 
functions: \link{sqlQuery} and \link{sqlSave}).}
}
\description{
Aster uses the following pair of tables to store graph data:
  - vertices table with unique key and optional attributes
  - Edges table with source, target and optional attributes
Also see \code{\link{toaGraph}}
Graph validation checks for the following:
\itemize{
  \item Both tables exist (error returned).
  \item Edge sources exist in the vertices table.
  \item Edge targets exist in the vertices table.
  \item No duplicate vertices defined.
  \item No duplicate edges defined.
  \item No loops (self-directed edges) defined.
}
}
\examples{
if(interactive()) {

# initialize connection to Lahman baseball database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")

# undirected graph
policeGraphUn = toaGraph(vertices="dallaspolice_officer_vertices", 
                         edges="dallaspolice_officer_edges_un", 
                         directed=FALSE, key="officer", 
                         source="officer1", target="officer2", 
                         vertexAttrnames = c("offense_count"),
                         edgeAttrnames = c("weight"))
validateGraph(conn, policeGraphUn)

# directed graph
policeGraphDi = toaGraph(edges="dallaspolice_officer_vertices", 
                         vertices="dallaspolice_officer_edges_di", 
                         directed=TRUE, key="officer", 
                         source="officer1", target="officer2", 
                         vertexAttrnames = c("offense_count"),
                         edgeAttrnames = c("weight"))
validateGraph(conn, policeGraphDi, weight=TRUE)

}
}

