% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_factors.R
\name{bart_factors}
\alias{bart_factors}
\title{Get Four Factor Statistics}
\usage{
bart_factors(
  year = current_season(),
  result = NULL,
  type = NULL,
  start = NULL,
  end = NULL,
  location = NULL,
  last = NULL
)
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{result}{Filters by result ('W' or 'L')}

\item{type}{Filter by game type ('nc', 'conf', or 'post')}

\item{start}{Filters by starting date (YYYY-MM-DD)}

\item{end}{Filters by ending date (YYYY-MM-DD)}

\item{location}{Filters by game location ('H', 'A', or 'N')}

\item{last}{Filters by last x games played}
}
\value{
Returns a tibble with 22 columns:
\describe{
  \item{\code{team}}{character.}
  \item{\code{conf}}{character.}
  \item{\code{rating}}{double. Expected scoring margin against an average
  team on a neutral court.}
  \item{\code{rank}}{double.}
  \item{\code{adj_o}}{double.}
  \item{\code{adj_o_rank}}{double.}
  \item{\code{adj_d}}{double.}
  \item{\code{adj_d_rank}}{double.}
  \item{\code{tempo}}{double.}
  \item{\code{off_ppp}}{double. Raw points scored per possession.}
  \item{\code{off_efg}}{double. Team effective FG\%.}
  \item{\code{off_to}}{double. Offensive turnover rate.}
  \item{\code{off_or}}{double. Offensive rebound rate.}
  \item{\code{off_ftr}}{double. Offensive free throw rate.}
  \item{\code{def_ppp}}{double. Raw points allowed per possession.}
  \item{\code{def_efg}}{double. Effective FG\% allowed.}
  \item{\code{def_to}}{double. Turnover rate forced.}
  \item{\code{def_or}}{double. Defensive rebound rate.}
  \item{\code{def_ftr}}{double. Free throw rate allowed.}
  \item{\code{wins}}{integer.}
  \item{\code{losses}}{integer.}
  \item{\code{games}}{integer.}
}
}
\description{
Returns four factor data and team records on a variety of splits, including
date range, quadrant level, opponent ranking, game location, and game type.
}
\details{
For a brief explanation of each factor and its computation, please visit
\href{https://kenpom.com/blog/four-factors/}{KenPom's blog}.
}
\examples{
\donttest{try(bart_factors(year=2022, start='2022-01-13', type='conf'))}

}
