% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.tna}
\alias{simulate.tna}
\title{Simulate Data from a Transition Network Analysis Model}
\usage{
\method{simulate}{tna}(
  object,
  nsim = 1,
  seed = NULL,
  max_len = 100L,
  na_range = c(0L, 0L),
  ...
)
}
\arguments{
\item{object}{A \code{tna} object. The edge weights must be transition
probabilities, i.e., the model must have \code{type = "relative"}.}

\item{nsim}{An \code{integer} giving the number of sequences to simulate.
The default is 1.}

\item{seed}{Ignored. Please use \code{\link[=set.seed]{set.seed()}} manually.}

\item{max_len}{An \code{integer} giving the maximum length of the simulated
sequences. When no missing values are generated, this is the length of
all simulated sequences.}

\item{na_range}{An \code{integer} vector of length 2 giving the minimum and
maximum number of missing values to generate for each sequence. The number
of missing values is drawn uniformly from this range. If both values are
zero (the default), no missing values are generated.}

\item{...}{Ignored.}
}
\value{
A \code{data.frame} of the simulated sequence data with \code{nsim} rows and
\code{max_len} columns.
}
\description{
Simulate Data from a Transition Network Analysis Model
}
\examples{
model <- tna(group_regulation)
sim <- simulate(model, nsim = 10, max_len = 10)

}
\seealso{
Basic functions
\code{\link{build_model}()},
\code{\link{hist.group_tna}()},
\code{\link{hist.tna}()},
\code{\link{import_data}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.tna}()},
\code{\link{plot_frequencies}()},
\code{\link{plot_frequencies.group_tna}()},
\code{\link{plot_mosaic}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{prepare_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.tna}()},
\code{\link{print.tna}()},
\code{\link{print.tna_data}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.tna}()},
\code{\link{tna-package}}
}
\concept{basic}
