% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.group_tna}
\alias{plot.group_tna}
\title{Plot a Grouped Transition Network Analysis Model}
\usage{
\method{plot}{group_tna}(x, title, which, ...)
}
\arguments{
\item{x}{A \code{group_model} object.}

\item{title}{A title for each plot. It can be a single string (the same one
will be used for all plots) or a list (one per group)}

\item{which}{An optional \code{integer} vector of groups to plot. By default, all
groups are plotted.}

\item{...}{Same as \code{\link[=plot.tna]{plot.tna()}}.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Plots a transition network of each cluster using \code{qgraph}.
}
\examples{
model <- group_model(engagement_mmm)
plot(model)

}
\seealso{
Basic functions
\code{\link{build_model}()},
\code{\link{hist.group_tna}()},
\code{\link{hist.tna}()},
\code{\link{import_data}()},
\code{\link{plot.tna}()},
\code{\link{plot_frequencies}()},
\code{\link{plot_frequencies.group_tna}()},
\code{\link{plot_mosaic}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{prepare_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.tna}()},
\code{\link{print.tna}()},
\code{\link{print.tna_data}()},
\code{\link{simulate.tna}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.tna}()},
\code{\link{tna-package}}
}
\concept{basic}
