% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rtmvnorm}
\alias{rtmvnorm}
\title{Random Generation for Truncated Multivariate Normal}
\usage{
rtmvnorm(mean, sigma, blc, lower, upper, init, burn = 10L)
}
\arguments{
\item{mean}{\code{n x p} matrix of means. The number of rows is the number 
of observations. The number of columns is the dimension of the problem.}

\item{sigma}{\code{p x p} covariance matrix.}

\item{blc}{\code{m x p} matrix of coefficients for linear inequality 
constraints.}

\item{lower}{\code{n x m} or \code{1 x m} matrix of lower bounds for 
truncation.}

\item{upper}{\code{n x m} or \code{1 x m} matrix of upper bounds for 
truncation.}

\item{init}{\code{n x p} or \code{1 x p} matrix of initial values.}

\item{burn}{Number of burn-in iterations. Defaults to 10.}
}
\value{
Returns a \code{n x p} matrix of random numbers following the 
  specified truncated multivariate normal distribution.
}
\description{
Draws from truncated multivariate normal distribution subject to 
linear inequality constraints represented by a matrix.
}
\examples{
# Example 1: full rank
d = 3;
rho = 0.9;
sigma = matrix(0, d, d);
sigma = rho^abs(row(sigma) - col(sigma));
blc = diag(1,d);
n = 1000;
mean = matrix(rep(1:d,n), nrow=n, ncol=d, byrow=TRUE);
lower = matrix(rep(-1,d), nrow=1);
upper = matrix(rep(1,d), nrow=1);
init = matrix(rep(0,d), nrow=1);
set.seed(1203)
result = rtmvnorm(mean, sigma, blc, lower, upper, init, burn=50)
apply(result, 2, summary)

# Example 2: non-full rank, invalid initial values
d = 3;
rho = 0.5;
sigma = matrix(0, d, d);
sigma = rho^abs(row(sigma) - col(sigma));
blc = matrix(c(1,1,1,0,1,0,1,0,1),ncol=d);
n = 100;
mean = matrix(rep(1:d,n), nrow=n, ncol=d, byrow=TRUE);
lower = matrix(rep(-1,d), nrow=1);
upper = matrix(rep(1,d), nrow=1);
init = matrix(rep(0.8,d), nrow=1);
set.seed(1228)
result = rtmvnorm(mean, sigma, blc, lower, upper, init, burn=50)
apply(result, 2, summary)

# Example 3: means, lower, or upper bounds differ across samples
d = 3;
rho = 0.5;
sigma = matrix(0, d, d);
sigma = rho^abs(row(sigma) - col(sigma));
blc = matrix(c(1,0,1,1,1,0),nrow=d-1,ncol=d,byrow=TRUE)
n = 100;
set.seed(3084)
mean = matrix(runif(n*d), nrow=n, ncol=d);
lower = matrix(rep(-1,d-1), nrow=1);
upper = matrix(rep(1,d-1), nrow=1);
init = matrix(rep(0.8,d), nrow=1);
result = rtmvnorm(mean, sigma, blc, lower, upper, init, burn=50)
apply(result, 2, summary)

}
