% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{display_message}
\alias{display_message}
\title{Display a message}
\usage{
display_message(target = NULL, message = NULL, verbose = FALSE, stdout = TRUE)
}
\arguments{
\item{target}{A session, window, or pane.}

\item{message}{A string. The message to display. Refer to the FORMATS
section of the tmux man page for the format.}

\item{verbose}{A logical. Print verbose logging as the format is parsed?
Default: \code{FALSE}.}

\item{stdout}{A logical. If \code{TRUE}, the message is printed to standard
output. If \code{FALSE}, the message is sent to \code{target}. Default: \code{TRUE}.}
}
\value{
A string if \code{stdout} is \code{TRUE}, otherwise \code{NULL}.
}
\description{
Display a message.
}
\note{
The \code{verbose} argument is not supported for tmux version < 2.9 and will be
ignored. If \code{verbose} is \code{TRUE} a warning will be given.
}
\examples{
\dontrun{
s <- new_session("jazz", height = 12)
display_message(s, "#{window_active}")
display_message(s, "session '#{session_name}' has height #{window_height}.")
kill_session(s)
}

}
