% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtm.R
\name{qtm}
\alias{qtm}
\title{Quick thematic map plot}
\usage{
qtm(
  shp = NULL,
  fill = tm_const(),
  col = tm_const(),
  size = tm_const(),
  shape = tm_const(),
  lwd = tm_const(),
  lty = tm_const(),
  fill_alpha = tm_const(),
  col_alpha = tm_const(),
  text = tm_const(),
  text_col = tm_const(),
  text_size = tm_const(),
  by = NULL,
  scale = NULL,
  title = NULL,
  crs = NULL,
  bbox = NULL,
  basemaps = NA,
  overlays = NA,
  zindex = NA,
  group = NA,
  group.control = "check",
  style = NULL,
  format = NULL,
  ...
)
}
\arguments{
\item{shp}{One of:
\itemize{
\item shape object, which is an object from a class defined by the \code{\link[sf:sf]{sf}}
or \code{\link[stars:st_as_stars]{stars}} package. Objects from the packages \code{sp}
and \code{raster} are also supported, but discouraged.
\item Not specified, i.e. \code{qtm()} is executed. In this case a plain interactive
map is shown.
\item An OpenStreetMap search string, e.g. \code{qtm("Amsterdam")}. In this case a
plain interactive map is shown positioned according to the results of the
search query (from OpenStreetMap nominatim)
}}

\item{fill, col, size, shape, lwd, lty, fill_alpha, col_alpha}{Visual variables.}

\item{text, text_col, text_size}{Visual variables.}

\item{by}{data variable name by which the data is split, or a vector of two
variable names to split the data by two variables (where the first is used
for the rows and the second for the columns). See also \code{\link[=tm_facets]{tm_facets()}}.}

\item{scale}{numeric value that serves as the global scale parameter. All font
sizes, symbol sizes, border widths, and line widths are controlled by this value.
The parameters \code{symbols.size}, \code{text.size}, and \code{lines.lwd} can be scaled
separately with respectively \code{symbols.scale}, \code{text.scale}, and
\code{lines.scale}. See also \code{...}.}

\item{title}{main title. For legend titles, use \code{X.legend}, where X is the
layer name (see \code{...}).}

\item{crs}{Either a \code{\link[sf:st_crs]{crs}} object or a character value
(\code{PROJ.4} character string). By default, the projection is used that is
defined in the \code{shp} object itself.}

\item{bbox}{bounding box. Argument passed on to \code{\link[=tm_shape]{tm_shape()}}}

\item{basemaps}{name(s) of the provider or an URL of a tiled basemap.
It is a shortcut to \code{\link[=tm_basemap]{tm_basemap()}}. Set to \code{NULL} to disable basemaps.
By default, it is set to the tmap option \code{basemaps}.}

\item{overlays}{name(s) of the provider or an URL of a tiled overlay map.
It is a shortcut to \code{\link[=tm_tiles]{tm_tiles()}}.}

\item{zindex}{zindex}

\item{group}{group}

\item{group.control}{group.control}

\item{style}{Layout options (see \code{\link[=tm_layout]{tm_layout()}}) that define the style.
See \code{\link[=tmap_style]{tmap_style()}} for details.}

\item{format}{Deprecated, see \code{\link[=tm_format]{tm_format()}} for alternatives}

\item{...}{arguments associated with the visual variables are passed on
to the layer functions \code{\link[=tm_polygons]{tm_polygons()}}, \code{\link[=tm_lines]{tm_lines()}}, \code{\link[=tm_symbols]{tm_symbols()}},
and \code{\link[=tm_text]{tm_text()}}.
For instance, \code{fill.scale} is the scale specifications of the fill color
of polygons (see \code{\link[=tm_polygons]{tm_polygons()}}).}
}
\value{
A \code{\link{tmap-element}}
}
\description{
Draw a thematic map quickly. This function is a convenient wrapper of the main
plotting method of stacking \code{\link{tmap-element}}s. Without arguments or with a
search term, this functions draws an interactive map.
}
\details{
The first argument is a shape object (normally specified by \code{\link[=tm_shape]{tm_shape()}}).
The next arguments, from \code{fill} to \code{raster}, are the aesthetics from the main
layers. The remaining arguments are related to the map layout. Any argument
from any main layer function, such as \code{\link[=tm_polygons]{tm_polygons()}}, can be specified (see \code{...}).
It is also possible to stack \code{\link{tmap-element}}s on a \code{qtm} plot. See examples.

By default, a scale bar is shown. This option can be set with \code{\link[=tmap_options]{tmap_options()}}
(argument \code{qtm.scalebar}). A minimap is shown by default when \code{qtm} is called
without arguments of with a search term. This option can be set with \code{\link[=tmap_options]{tmap_options()}}
(argument \code{qtm.minimap}).
}
\examples{
data(World, World_rivers, metro)

# just the map
qtm(World)

# choropleth
qtm(World, fill = "economy", style = "cobalt", crs = "+proj=eck4")

qtm(World, col = NULL) +
qtm(metro, size = "pop2010",
	size.legend = tm_legend("Metropolitan Areas"))

# dot map
\dontrun{
current.mode <- tmap_mode("view")
qtm(metro, bbox = "China")
tmap_mode(current.mode) # restore mode
}

\dontrun{
# without arguments, a plain interactive map is shown (the mode is set to view)
qtm()

# search query for OpenStreetMap nominatim
qtm("Amsterdam")
}
}
\references{
Tennekes, M., 2018, {tmap}: Thematic Maps in {R},
Journal of Statistical Software, 84(6), 1-39, \doi{10.18637/jss.v084.i06}
}
