% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_misc_elements.R
\name{tm_xlab}
\alias{tm_xlab}
\alias{tm_ylab}
\title{Axis labels}
\usage{
tm_xlab(text, size = 0.8, rotation = 0, space = NA)

tm_ylab(text, size = 0.8, rotation = 90, space = NA)
}
\arguments{
\item{text}{text for the axis}

\item{size}{fontsize, by default 0.8}

\item{rotation}{rotation angle in degrees. By default, 0 for the x axis label and 90 for the y axis label.}

\item{space}{space between labels and the map in numbers of line heights. By default, it is 0, unless grid labels are plotted outside the frame (i.e., \code{\link{tm_grid}} is called with \code{labels.inside.frame = FALSE}). In that case, \code{space} corresponds to the height of one line, taking the grid label size into account.}
}
\description{
Add axis labels
}
\examples{
data(World)

qtm(World, fill="#FFF8DC", projection="longlat", inner.margins=0) +
	tm_grid(x = seq(-180, 180, by=20), y=seq(-90,90,by=10), col = "gray70") +
	tm_xlab("Longitude") +
	tm_ylab("Latitude")
}
