% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_shape.R
\name{crop_shape}
\alias{crop_shape}
\title{Crop shape object}
\usage{
crop_shape(x, y, ...)
}
\arguments{
\item{x}{shape object, i.e. an object from class \code{\link[sp:Spatial]{Spatial-class}} or \code{\link[raster:Raster-class]{Raster}}}

\item{y}{bounding box (2 by 2 matrix), an \code{\link[raster:extent]{extent}}, or a shape object from which the bounding box is extracted.}

\item{...}{arguments passed on to \code{\link[raster:crop]{crop}}}
}
\description{
Crop a shape object (from class \code{\link[sp:Spatial]{Spatial-class}} or \code{\link[raster:Raster-class]{Raster}}).
}
\details{
This function is a wrapper around \code{\link[raster:crop]{crop}} from the raster package. It does two things in addition: \code{\link[sp:SpatialGrid]{SpatialGrid}} objects are allowed, and if \code{y} is a shape object with a different projection, it is temporarily reprojected in order to obtain a bounding box by which \code{x} is cropped.
}
\examples{
data(Europe, land)

land_europe <- crop_shape(land, Europe)

qtm(land_europe, raster="trees", style="natural")
}
\seealso{
\code{\link{bb}}
}

