% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_tmap.R
\name{save_tmap}
\alias{save_tmap}
\title{Save tmap}
\usage{
save_tmap(tm = NULL, filename = NULL, width = NA, height = NA,
  units = NA, dpi = 300, outer.margins = 0, asp = NULL, scale = NA,
  insets_tm = NULL, insets_vp = NULL, verbose = TRUE, ...)
}
\arguments{
\item{tm}{tmap object}

\item{filename}{filename including extension, and optionally the path. The extensions pdf, eps, svg, wmf (Windows only), png, jpg, bmp, or tiff are supported. If the extension is missing, the file will be saved as png image}

\item{width}{width. Units are set with the argument \code{units}. If set to \code{NA} and \code{height} is specified, it will be \code{height} * aspect ratio. If both \code{width} and \code{height} are not specified, then the width of the current plotting window will be taken.}

\item{height}{height. Units are set with the argument \code{units}. If set to \code{NA} and \code{width} is specified, it will be \code{width} / aspect ratio. If both \code{width} and \code{height} are not specified, then the height of the current plotting window will be taken.}

\item{units}{units for width and height (\code{"in"}, \code{"cm"}, or \code{"mm"}). By default, pixels (\code{"px"}) are used if either width or height is set to a value greater than 50. Else, the units are inches (\code{"in"})}

\item{dpi}{dots per inch. Only applicable for raster graphics.}

\item{outer.margins}{overrides the outer.margins argument of \code{\link{tm_layout}} (unless set to \code{NA})}

\item{asp}{if specified, it overrides the asp argument of \code{\link{tm_layout}}. Tip: set to \code{0} if map frame should be placed on the edges of the image.}

\item{scale}{overrides the scale argument of \code{\link{tm_layout}} (unless set to \code{NA})}

\item{insets_tm}{tmap object of an inset map, or a list of tmap objects of multiple inset maps. The number of tmap objects should be equal to the number of viewports specified with \code{insets_vp}.}

\item{insets_vp}{\code{\link[grid:viewport]{viewport}} of an inset map, or a list of \code{\link[grid:viewport]{viewport}}s of multiple inset maps. The number of viewports should be equal to the number of tmap objects specified with \code{insets_tm}.}

\item{verbose}{should information messages be returned?}

\item{...}{arguments passed on to device functions or to \code{\link[htmlwidgets:saveWidget]{saveWidget}}}
}
\description{
Save tmap to a file, such as png, jpg, or pdf.
}
\examples{
\dontrun{
	data(NLD_muni, NLD_prov)
	m <- tm_shape(NLD_muni) +
		     tm_fill(col="population", convert2density=TRUE, 
                 style="kmeans", 
                 title=expression("Population (per " * km^2 * ")"), 
                 legend.hist=FALSE) +
		     tm_borders("black", alpha=.5) + 
		 tm_shape(NLD_prov) +
		     tm_borders("grey25", lwd=2) +
	     tm_format_NLD(inner.margins = c(.02, .15, .06, .15)) + 
	     tm_scale_bar(position = c("left", "bottom")) +
	     tm_compass(position=c("right", "bottom")) + 
	     tm_style_classic()
	
	save_tmap(m, "choropleth.png", height=7)
	
	data(World)
	m2 <- tm_shape(World) +
		tm_fill("well_being", id="name", title="Well-being") +
		tm_format_World()

	# save image
	save_tmap(m2, "World_map.png", width=1920, height=1080, asp=0)

	# cut left inner margin to make sure Antarctica is snapped to frame
	save_tmap(m2 + tm_layout(inner.margins = c(0, -.1, 0.05, 0.01)), 
        "World_map2.png", width=1920, height=1080, asp=0)
	
	# save interactive plot
	save_tmap(m2, "World_map.html")
}
}
