% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_coef_with_r2.R
\name{adjust_coef_with_r2}
\alias{adjust_coef_with_r2}
\title{Adjust a regression coefficient using the partial R2
for an unmeasured confounder-exposure relationship and unmeasured confounder-
outcome relationship}
\usage{
adjust_coef_with_r2(
  effect_observed,
  se,
  df,
  confounder_exposure_r2,
  confounder_outcome_r2,
  verbose = TRUE,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{effect_observed}{Numeric. Observed exposure - outcome effect from a regression
model. This is the point estimate (beta coefficient)}

\item{se}{Numeric. Standard error of the \code{effect_observed} in the previous parameter.}

\item{df}{Numeric positive value. Residual degrees of freedom for the model
used to estimate the observed exposure - outcome effect. This is the total
number of observations minus the number of parameters estimated in your
model. Often for models estimated with an intercept this is N - k - 1
where k is the number of predictors in the model.}

\item{confounder_exposure_r2}{Numeric value between 0 and 1. The assumed partial R2 of
the unobserved confounder with the exposure given the measured covariates.}

\item{confounder_outcome_r2}{Numeric value between 0 and 1. The assumed partial R2 of
the unobserved confounder with the outcome given the exposure and
the measured covariates.}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{alpha}{Significance level. Default = \code{0.05}.}

\item{...}{Optional arguments passed to the \code{\link[sensemakr:adjusted_estimate]{sensemakr::adjusted_estimate()}}
function.}
}
\value{
A data frame.
}
\description{
This function wraps the \code{\link[sensemakr:adjusted_estimate]{sensemakr::adjusted_estimate()}} and
\code{\link[sensemakr:adjusted_estimate]{sensemakr::adjusted_se()}} functions.
}
\examples{
adjust_coef_with_r2(0.5, 0.1, 102, 0.05, 0.1)
}
\references{
Carlos Cinelli, Jeremy Ferwerda and Chad Hazlett (2021).
sensemakr: Sensitivity Analysis
Tools for Regression Models. R package version 0.1.4.
https://CRAN.R-project.org/package=sensemakr
}
