% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip_with_binary.R
\name{tip_rr_with_binary}
\alias{tip_rr_with_binary}
\title{Tip an observed relative risk with a binary confounder.}
\usage{
tip_rr_with_binary(
  effect,
  exposed_p,
  unexposed_p,
  outcome_association,
  verbose = TRUE
)
}
\arguments{
\item{effect}{Numeric positive value. Observed exposure - outcome relative risk.
This can be the point estimate, lower confidence bound, or upper
confidence bound.}

\item{exposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the exposed population}

\item{unexposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the unexposed population}

\item{outcome_association}{Numeric positive value. Estimated association
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}
}
\description{
Choose two of the following three to specify, and the third will be estimated:
\itemize{
\item \code{exposed_p}
\item \code{unexposed_p}
\item \code{outcome_association}
}

Alternatively, specify all three and the function will return the number of unmeasured
confounders specified needed to tip the analysis.
}
