% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicitationFunctions.R
\name{fitExpertBetaDistributions}
\alias{fitExpertBetaDistributions}
\title{Fit beta distributions for specified expert weights}
\usage{
fitExpertBetaDistributions(expertWeights)
}
\arguments{
\item{expertWeights}{A data frame or matrix containing expert weights}
}
\value{
Parameters for individual beta distributions
}
\description{
Fits beta distribution to the specified expert weights using \code{SHELF::fitdist}.
For each distribution, shape parameters are fitted and returned.
}
\details{
The argument \code{expertWeights} must be a data frame or a matrix that represents the assigned
expert weights. It should contain a row for each expert and 10 columns for different weights.
The first column represents weights 0-0.1, second column represents weights 0.1-0.2 and so on.
}
\examples{

fitExpertBetaDistributions(
  expertWeights =
    rbind(
      c(0, 0, 0, 0, 2, 3, 3, 2, 0, 0),
      c(0, 0, 0, 1, 2, 4, 2, 1, 0, 0),
      c(0, 0, 0, 2, 2, 2, 2, 2, 0, 0)
    )
)
}
