% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createNewTrialData.R
\name{createNewTrialData}
\alias{createNewTrialData}
\title{Data on new trial in target population}
\usage{
createNewTrialData(nTotal, treatmentEffectEstimate, standardError)
}
\arguments{
\item{nTotal}{The total sample size.}

\item{treatmentEffectEstimate}{Treatment effect estimate.}

\item{standardError}{Standard error of the treatment effect estimate.}
}
\value{
A numeric vector with data on the new trial, incl. quantiles of an assumed normal data likelihood.
}
\description{
Creates a vector containing data on the new trial in the target population. This may be hypothetical data in the planning stage.
}
\examples{
newTrialData <- createNewTrialData(
  nTotal = 30, treatmentEffectEstimate = 1.27,
  standardError = 0.95
)
}
\seealso{
\code{\link{createPosteriorData}}, \code{\link{createTippingPointData}}
}
