% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex.R
\name{latexmk}
\alias{latexmk}
\alias{pdflatex}
\alias{xelatex}
\alias{lualatex}
\title{Compile a LaTeX document}
\usage{
latexmk(
  file,
  engine = c("pdflatex", "xelatex", "lualatex", "latex"),
  bib_engine = c("bibtex", "biber"),
  engine_args = NULL,
  emulation = TRUE,
  min_times = 1,
  max_times = 10,
  install_packages = emulation && tlmgr_available(),
  pdf_file = gsub("tex$", "pdf", file),
  clean = TRUE
)

pdflatex(...)

xelatex(...)

lualatex(...)
}
\arguments{
\item{file}{A LaTeX file path.}

\item{engine}{A LaTeX engine (can be set in the global option
\code{tinytex.engine}, e.g., \code{options(tinytex.engine = 'xelatex')}).}

\item{bib_engine}{A bibliography engine (can be set in the global option
\code{tinytex.bib_engine}).}

\item{engine_args}{Command-line arguments to be passed to \code{engine} (can
be set in the global option \code{tinytex.engine_args}, e.g.,
\code{options(tinytex.engine_args = '-shell-escape'}).}

\item{emulation}{Whether to emulate the executable \command{latexmk} using R.}

\item{min_times, max_times}{The minimum and maximum number of times to rerun
the LaTeX engine when using emulation. You can set the global options
\code{tinytex.compile.min_times} or \code{tinytex.compile.max_times}, e.g.,
\code{options(tinytex.compile.max_times = 3)}.}

\item{install_packages}{Whether to automatically install missing LaTeX
packages found by \code{\link{parse_packages}()} from the LaTeX log. This
argument is only for the emulation mode and TeX Live.}

\item{pdf_file}{Path to the PDF output file. By default, it is under the same
directory as the input \code{file} and also has the same base name. When
\code{engine == 'latex'}, this will be a DVI file.}

\item{clean}{Whether to clean up auxiliary files after compilation (can be
set in the global option \code{tinytex.clean}, which defaults to
\code{TRUE}).}

\item{...}{Arguments to be passed to \code{latexmk()} (other than
\code{engine} and \code{emulation}).}
}
\value{
A character string of the path of the output file (i.e., the value of
  the \code{pdf_file} argument).
}
\description{
The function \code{latexmk()} emulates the system command \command{latexmk}
(\url{https://ctan.org/pkg/latexmk}) to compile a LaTeX document. The
functions \code{pdflatex()}, \code{xelatex()}, and \code{lualatex()} are
wrappers of \code{latexmk(engine =, emulation = TRUE)}.
}
\details{
The \command{latexmk} emulation works like this: run the LaTeX engine once
(e.g., \command{pdflatex}), run \command{makeindex} to make the index if
necessary (the \file{*.idx} file exists), run the bibliography engine
\command{bibtex} or \command{biber} to make the bibliography if necessary
(the \file{*.aux} or \file{*.bcf} file exists), and finally run the LaTeX
engine a number of times (the maximum is 10 by default) to resolve all
cross-references.

If \code{emulation = FALSE}, you need to make sure the executable
\command{latexmk} is available in your system, otherwise \code{latexmk()}
will fall back to \code{emulation = TRUE}. You can set the global option
\code{options(tinytex.latexmk.emulation = FALSE)} to always avoid emulation
(i.e., always use the executable \command{latexmk}).

The default command to generate the index (if necessary) is
\command{makeindex}. To change it to a different command (e.g.,
\command{zhmakeindex}), you may set the global option
\code{tinytex.makeindex}. To pass additional command-line arguments to the
command, you may set the global option \code{tinytex.makeindex.args} (e.g.,
\code{options(tinytex.makeindex = 'zhmakeindex', tinytex.makeindex.args =
c('-z', 'pinyin'))}).

If you are using the LaTeX distribution TinyTeX, but its path is not in the
\code{PATH} variable of your operating system, you may set the global option
\code{tinytex.tlmgr.path} to the full path of the executable \command{tlmgr},
so that \code{latexmk()} knows where to find executables like
\command{pdflatex}. For example, if you are using Windows and your TinyTeX is
on an external drive \file{Z:/} under the folder \file{TinyTeX}, you may set
\code{options(tinytex.tlmgr.path = "Z:/TinyTeX/bin/win32/tlmgr.bat")}.
Usually you should not need to set this option because TinyTeX can add itself
to the \code{PATH} variable during installation or via
\code{\link{use_tinytex}()}. In case both methods fail, you can use this
manual approach.
}
