% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.tinytests}
\alias{summary.tinytests}
\alias{all_pass}
\alias{any_pass}
\alias{all_fail}
\alias{any_fail}
\alias{[.tinytests}
\alias{tinytests}
\alias{print.tinytests}
\alias{as.data.frame.tinytests}
\title{Tinytests object}
\usage{
\method{summary}{tinytests}(object, ...)

all_pass(x)

any_pass(x)

all_fail(x)

any_fail(x)

\method{[}{tinytests}(x, i)

\method{print}{tinytests}(x, passes = getOption("tt.pr.passes", FALSE),
  limit = getOption("tt.pr.limit", 7), nlong = getOption("tt.pr.nlong",
  3), ...)

\method{as.data.frame}{tinytests}(x, ...)
}
\arguments{
\item{object}{a \code{tinytests} object}

\item{...}{passed to \code{\link{format.tinytest}}}

\item{x}{a \code{tinytests} object}

\item{i}{an index}

\item{passes}{\code{[logical]} Toggle: print passing tests?}

\item{limit}{\code{[numeric]} Max number of results to print}

\item{nlong}{\code{[numeric]} First \code{nlong} results are printed in long format.}
}
\value{
For \code{summary} a \code{\link{table}} object

For \code{all_pass}, \code{any_pass}, \code{all_fail}, \code{any_fail}: 
 a single \code{logical}

For \code{`[.tinytests`} a \code{tinytests} object.

For \code{as.data.frame.} a data frame.
}
\description{
An object of class \code{tinytests} (note: plural) results
from running multiple tests from script. E.g. by running
\code{\link{run_test_file}}.
}
\section{Details}{


By default, the first 3 failing test results are printed in long form,
the next 7 failing test results are printed in short form and all other 
failing tests are not printed. These defaults can be changed by passing options
to  \code{print.tinytest}, or by setting one or more of the following global
options:
\itemize{
\item{\code{tt.pr.passes} Set to \code{TRUE} to print output of non-failing tests.}
\item{\code{tt.pr.limit} Max number of results to print (e.g. \code{Inf})}
\item{\code{tt.pr.nlong} The number of results to print in long format (e.g. \code{Inf}).}
}

For example, set \code{options(tt.pr.limit=Inf)} to print all test results.
Furthermore, there is the option
\itemize{
\item{\code{tt.pr.color},}
}
which determines whether colored output is printed.
If R is running in a dumb terminal (detected by comparing 
environment variable \code{"TERM"} to \code{"dumb"}), then
this option is set to \code{FALSE} when the package is loaded.
}

\examples{
# create a test file in tempdir
tests <- "
addOne <- function(x) x + 2

expect_true(addOne(0) > 0)
expect_equal(2, addOne(1))
"
testfile <- tempfile(pattern="test_", fileext=".R")
write(tests, testfile)

# extract testdir
testdir <- dirname(testfile)
# run all files starting with 'test' in testdir
out <- run_test_dir(testdir)
#
# print results
print(out)
summary(out)
dat <- as.data.frame(out)
out[1]

}
\seealso{
Other test-files: \code{\link{build_install_test}},
  \code{\link{run_test_dir}}, \code{\link{run_test_file}},
  \code{\link{test_package}}
}
\concept{test-files}
