% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpar.R
\name{tpar}
\alias{tpar}
\title{Set or query graphical parameters}
\usage{
tpar(...)
}
\arguments{
\item{...}{arguments of the form \code{key = value}. This includes all of the
parameters typically supported by \code{\link[graphics]{par}}, as well as
the \code{tinyplot}-specific ones described in the 'Graphical Parameters'
section below.}
}
\value{
When parameters are set, their previous values are returned in an
invisible named list. Such a list can be passed as an argument to \code{tpar} to
restore the parameter values.

When just one parameter is queried, the value of that parameter is returned
as (atomic) vector. When two or more parameters are queried, their values
are returned in a list, with the list names giving the parameters.

Note the inconsistency: setting one parameter returns a list, but querying
one parameter returns a vector.
}
\description{
Extends \code{\link[graphics]{par}}, serving as a (near) drop-in
replacement for setting or querying graphical parameters. The key
differences is that, beyond supporting the standard group of R graphical
parameters in \code{\link[graphics]{par}}, \code{tpar} also supports additional
graphical parameters that are provided by \code{tinyplot}. Similar to
\code{\link[graphics]{par}}, parameters are set by passing appropriate
\code{key = value} argument pairs, and multiple parameters can be set or queried
at the same time.
}
\details{
The \code{tinyplot}-specific parameters are saved in an internal
environment called \code{.tpar} for performance and safety reasons. However,
they can also be set at package load time via \code{\link[base]{options}},
which may prove convenient for users that want to enable different default
behaviour at startup (e.g., through an \code{.Rprofile} file). These options all
take a \verb{tinyplot_*} prefix, e.g.
\code{options(tinyplot_grid = TRUE, tinyplot_facet.bg = "grey90")}.

For their part, any "base" graphical parameters are caught dynamically and
passed on to \code{\link[graphics]{par}} as appropriate. Technically, only
parameters that satisfy \code{par(..., no.readonly = TRUE)} are evaluated.

However, note the important distinction: \code{tpar} only evaluates parameters
from \code{\link[graphics]{par}} if they are passed \emph{explicitly} by the
user. This means that \code{tpar} should not be used to capture the (invisible)
state of a user's entire set of graphics parameters, i.e. \code{tpar()} !=
\code{par()}. If you want to capture the \emph{all} existing graphics settings, then
you should rather use \code{par()} instead.
}
\section{Additional Graphical Parameters}{


\tabular{lll}{
\code{facet.cex} \tab\tab Expansion factor for facet titles. Defaults to \code{1}.\cr
\tab\tab\cr
\tab\tab\cr
\code{facet.font} \tab\tab An integer corresponding to the desired font face for facet titles. For most font families and graphics devices, one of four possible values: \code{1} (regular), \code{2} (bold), \code{3} (italic), or \code{4} (bold italic). Defaults to \code{NULL}, which is equivalent to \code{1} (i.e., regular).\cr
\tab\tab\cr
\tab\tab\cr
\code{facet.col} \tab\tab Character or integer specifying the facet text colour. If an integer, will correspond to the user's default global colour palette (see \code{\link[grDevices]{palette}}). Defaults to \code{NULL}, which is equivalent to "black".\cr
\tab\tab\cr
\tab\tab\cr
\code{facet.bg} \tab\tab Character or integer specifying the facet background colour. If an integer, will correspond to the user's default colour palette (see \code{\link[grDevices]{palette}}). Passed \code{\link[graphics]{rect}}. Defaults to \code{NULL} (none).\cr
\tab\tab\cr
\tab\tab\cr
\code{facet.border} \tab\tab Character or integer specifying the facet border colour. If an integer, will correspond to the users default colour palette (see \code{\link[grDevices]{palette}}). Passed \code{\link[graphics]{rect}}. Defaults to \code{NA} (none).\cr
\tab\tab\cr
\tab\tab\cr
\code{file.height} \tab\tab Numeric specifying the height (in inches) of any plot that is written to disk using the \code{tinyplot(..., file = X)} argument. Defaults to 7.\cr
\tab\tab\cr
\tab\tab\cr
\code{file.width} \tab\tab Numeric specifying the width (in inches) of any plot that is written to disk using the \code{tinyplot(..., file = X)} argument. Defaults to 7.\cr
\tab\tab\cr
\tab\tab\cr
\code{file.res} \tab\tab Numeric specifying the resolution (in dots per square inch) of any plot that is written to disk in bitmap format (i.e., PNG or JPEG) using the \code{tinyplot(..., file = X)} argument. Defaults to 300.\cr
\tab\tab\cr
\tab\tab\cr
\code{fmar} \tab\tab A numeric vector of form \code{c(b,l,t,r)} for controlling the (base) margin padding, in terms of lines, between the individual facets in a faceted plot. Defaults to \code{c(1,1,1,1)}, i.e. a single line of padding around each facet. If more that three facets are detected, the \code{fmar} parameter is scaled by 0.75 (i.e., three-quarters) to reduce the excess whitespace that would otherwise arise due to the absent axes lines and labels. (An exception is made for 2x2 plots to better match the \code{cex} expansion logic of the base graphics system under this particular layout.) Similarly, note that an extra 0.5 lines is subtracted from each side of the facet padding for plots that aren't framed, to reduce excess whitespace.\cr
\tab\tab\cr
\tab\tab\cr
\code{grid} \tab\tab Logical indicating whether a background panel grid should be added to plots automatically. Defaults to NULL, which is equivalent to \code{FALSE}.\cr
\tab\tab\cr
\tab\tab\cr
\code{lmar} \tab\tab A numeric vector of form \code{c(inner, outer)} that gives the margin padding, in terms of lines, around the automatic \code{tinyplot} legend. Defaults to \code{c(1.0, 0.1)}, where the first number represents the "inner" margin between the legend and the plot region, and the second number represents the "outer" margin between the legend and edge of the graphics device. (Note that an exception for the definition of the "outer" legend margin occurs when the legend placement is \code{"top!"}, since the legend is placed above the plot region but below the main title. In such cases, the outer margin is relative to the existing gap between the title and the plot region, which is itself determined by \code{par("mar")[3]}.)\cr
\tab\tab\cr
\tab\tab\cr
\code{ribbon.alpha} \tab\tab Numeric factor in the range \verb{[0,1]} for modifying the opacity alpha of "ribbon" and "area" (and alike) type plots. Default value is \code{0.2}.\cr
}
}

\examples{
# Return a list of existing base and tinyplot graphic params
tpar("las", "pch", "facet.bg", "facet.cex", "grid")

# Simple facet plot with these default values
tinyplot(mpg ~ wt, data = mtcars, facet = ~am)

# Set params to something new. Similar to graphics::par(), note that we save
# the existing values at the same time by assigning to an object.
op = tpar(
   las       = 1,
   pch       = 2,
   facet.bg  = "grey90",
   facet.cex = 2,
   grid      = TRUE
)

# Re-plot with these new params
tinyplot(mpg ~ wt, data = mtcars, facet = ~am)

# Reset back to original values
tpar(op)

# Important: tpar() only evalutes parameters that have been passed explicitly
#   by the user. So it it should not be used to query and set (restore)
#   parameters that weren't explicitly requested, i.e. tpar() != par().

# Note: The tinyplot-specific parameters can also be be set via `options`
#   with a `tinyplot_*` prefix, which can be convenient for enabling
#   different default behaviour at startup time (e.g., via an .Rprofile
#   file). Example:
# options(tinyplot_grid = TRUE, tinyplot_facet.bg = "grey90")

}
