% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_data}
\alias{import_data}
\title{Directly Return a Data-set From a Package}
\usage{
import_data(package, dataname, lib.loc = .libPaths())
}
\arguments{
\item{package}{a single string, giving the name of the R-package.}

\item{dataname}{a single string, giving the name of the data set.}

\item{lib.loc}{character vector specifying library search path
(the location of R library trees to search through). \cr
The \code{lib.loc} argument would usually be \code{.libPaths()}. \cr
See also \link[base]{loadNamespace}.}
}
\value{
Returns the data directly.
Thus, one can assign the data like so: \code{mydata <- import_data(...)}.
}
\description{
The \code{import_data()} function gets a specified data set from a package. \cr
Unlike \code{utils::data()}, the \code{import_data()} function returns the data set directly,
and allows assigning the data set like so: \cr
\code{mydata <- import_data(...)}. \cr
}
\examples{

d <- import_data("datasets", "cars")
head(d)



}
\seealso{
\link{tinycodet_import}
}
