% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_plots.R
\name{draw_volcano}
\alias{draw_volcano}
\title{draw a volcano plot}
\usage{
draw_volcano(
  deg,
  lab = NA,
  xlab.package = TRUE,
  pvalue_cutoff = 0.05,
  logFC_cutoff = 1,
  pkg = 1,
  adjust = FALSE,
  symmetry = FALSE,
  color = c("#2874C5", "grey", "#f87669")
)
}
\arguments{
\item{deg}{a data.frame created by Differential analysis}

\item{lab}{label for  x axis in volcano plot, if NA , x axis names by package}

\item{xlab.package}{whether to use the package name as the x axis name}

\item{pvalue_cutoff}{Cutoff value of pvalue,0.05 by default.}

\item{logFC_cutoff}{Cutoff value of logFC,1 by default.}

\item{pkg}{a integer ,means which Differential analysis packages you used,we support three packages by now, 1,2,3,4 respectively means "DESeq2","edgeR","limma(voom)","limma"}

\item{adjust}{a logical value, would you like to use adjusted pvalue to draw this plot,FAlSE by default.}

\item{symmetry}{a logical value ,would you like to get your plot symmetrical}

\item{color}{color vector}
}
\value{
a volcano plot according to logFC and P.value(or adjust P.value)
}
\description{
warning a volcano plot for Differential analysis result in data.frame format.
}
\examples{
head(deseq_data)
draw_volcano(deseq_data)
draw_volcano(deseq_data,pvalue_cutoff = 0.01,logFC_cutoff = 2)
draw_volcano(deseq_data,color = c("darkgreen", "darkgrey", "#B2182B"))
}
\seealso{
\code{\link{draw_heatmap}};\code{\link{draw_pca}};\code{\link{draw_venn}}
}
\author{
Xiaojie Sun
}
