% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfnetwork.R
\name{simulate_sfnetwork}
\alias{simulate_sfnetwork}
\title{Simulate GMRF for stream network}
\usage{
simulate_sfnetwork(sfnetwork_mesh, theta, n = 1, what = c("samples", "Q"))
}
\arguments{
\item{sfnetwork_mesh}{Output from \code{\link{sfnetwork_mesh}}}

\item{theta}{Decorrelation rate}

\item{n}{number of simulated GMRFs}

\item{what}{Whether to return the simulated GMRF or its precision matrix}
}
\value{
a matrix of simulated values for a Gaussian Markov random field
arising from a stream-network spatial domain, with row for each spatial random
effect and \code{n} columns, using the sparse precision matrix
defined in Charsley et al. (2023)
}
\description{
Simulate values from a GMRF using a tail-up exponential
model on a stream network
}
\references{
Charsley, A. R., Gruss, A., Thorson, J. T., Rudd, M. B., Crow, S. K.,
David, B., Williams, E. K., & Hoyle, S. D. (2023). Catchment-scale
stream network spatio-temporal models, applied to the freshwater stages
of a diadromous fish species, longfin eel (Anguilla dieffenbachii).
Fisheries Research, 259, 106583. \doi{10.1016/j.fishres.2022.106583}
}
