% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{simulate.tinyVAST}
\alias{simulate.tinyVAST}
\title{Simulate new data from a fitted model}
\usage{
\method{simulate}{tinyVAST}(
  object,
  nsim = 1L,
  seed = sample.int(1e+06, 1L),
  type = c("mle-eb", "mle-mvn"),
  ...
)
}
\arguments{
\item{object}{output from \code{\link[=tinyVAST]{tinyVAST()}}}

\item{nsim}{how many simulations to do}

\item{seed}{random seed}

\item{type}{How parameters should be treated. \code{"mle-eb"}: fixed effects
are at their maximum likelihood (MLE) estimates  and random effects are at
their empirical Bayes (EB) estimates. \code{"mle-mvn"}: fixed effects are at
their MLEs but random effects are taken from a single approximate sample.
This latter option is a suggested approach if these simulations will be
used for goodness of fit testing (e.g., with the DHARMa package).}

\item{...}{not used}
}
\value{
A matrix with row for each row of \code{data} in the fitted model and \code{nsim}
columns, containing new samples from the fitted model.
}
\description{
\code{simulate.tinyVAST} is an S3 method for producing a matrix of simulations from
a fitted model. It can be used with the \pkg{DHARMa} package
among other uses.  Code is modified from the version in sdmTMB
}
\examples{
set.seed(101)
x = seq(0, 2*pi, length=100)
y = sin(x) + 0.1*rnorm(length(x))
fit = tinyVAST( data=data.frame(x=x,y=y), formula = y ~ s(x) )
simulate(fit, nsim=100, type="mle-mvn")

if(requireNamespace("DHARMa")){
  # simulate new data conditional on fixed effects
  # and sampling random effects from their predictive distribution
  y_iz = simulate(fit, nsim=500, type="mle-mvn")

  # Visualize using DHARMa
  res = DHARMa::createDHARMa( simulatedResponse = y_iz,
                      observedResponse = y,
                      fittedPredictedResponse = fitted(fit) )
  plot(res)
}
}
