% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setCurrentTime}
\alias{setCurrentTime}
\title{Adjust the time of the current time bar}
\usage{
setCurrentTime(id, time)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{time}{The new date/time}
}
\description{
Adjust the time of the current time bar
}
\examples{

timevis() \%>\%
  setCurrentTime(Sys.Date())

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Set current time to beginning of today")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis()
    )
    observeEvent(input$btn, {
      setCurrentTime("timeline", Sys.Date())
    })
  }
)
}
}
