% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tk_get_timeseries.R
\name{tk_get_timeseries}
\alias{tk_get_timeseries}
\alias{tk_get_timeseries_signature}
\alias{tk_get_timeseries_summary}
\title{Get summary attributes from a time-series index}
\usage{
tk_get_timeseries_signature(idx)

tk_get_timeseries_summary(idx)
}
\arguments{
\item{idx}{A time-series index that is a vector of dates or datetimes.}
}
\value{
Returns a \code{tibble} object describing the timeseries.
}
\description{
Get summary attributes from a time-series index
}
\details{
\code{tk_get_timeseries_signature} decomposes the timeseries into commonly
needed features such as
numeric value, differences,
year, month, day, day of week, day of month,
day of year, hour, minute, second.

\code{tk_get_timeseries_summary} returns the summary returns the
start, end, units, scale, and a "summary" of the timeseries differences
in seconds including
the minimum, 1st quartile, median, mean, 3rd quartile, and maximum frequency.
The timeseries
differences give the user a better picture of the index frequency
so the user can understand the level of regularity or irregularity.
A perfectly regular time series will have equal values in seconds for each metric.
However, this is not often the case.

\strong{Important Note}: These functions only work with time-based indexes in
datetime, date, yearmon, and yearqtr values. Regularized dates cannot be decomposed.
}
\examples{
library(tidyquant)
library(timetk)

# Works with time-based tibbles
FB_tbl <- FANG \%>\% filter(symbol == "FB")
FB_idx <- tk_index(FB_tbl)

tk_get_timeseries_signature(FB_idx)
tk_get_timeseries_summary(FB_idx)


# Works with dates in any periodicity
idx_weekly <- seq.Date(from = ymd("2016-01-01"), by = 'week', length.out = 6)

tk_get_timeseries_signature(idx_weekly)
tk_get_timeseries_summary(idx_weekly)


# Works with zoo yearmon and yearqtr classes
idx_yearmon <- seq.Date(from       = ymd("2016-01-01"),
                        by         = "month",
                        length.out = 12) \%>\%
    as.yearmon()

tk_get_timeseries_signature(idx_yearmon)
tk_get_timeseries_summary(idx_yearmon)

}
\seealso{
\code{\link[=tk_index]{tk_index()}}, \code{\link[=tk_augment_timeseries_signature]{tk_augment_timeseries_signature()}}, \code{\link[=tk_make_future_timeseries]{tk_make_future_timeseries()}}
}
