# Set number of data.table threads to 2
data.table::setDTthreads(threads = 2L)
# Set number of collapse threads to 1
collapse::set_collapse(nthreads = 1L)

testthat::test_that("univariate", {
  uts <- ts(cumsum(1 + round(rnorm(100), 2)),
            start = c(1954, 7), frequency = 12)
  uts_tbl <- ts_as_tibble(uts)
  testthat::expect_equal(
    uts_tbl,
    dplyr::tibble(
      time = as.double(time(uts)),
      value = as.vector(uts)
    )
  )
  testthat::expect_equal(
    uts_tbl,
    ts_as_tibble.default(uts)
  )
})

testthat::test_that("multivariate", {
  mts <- ts(matrix(rnorm(300), 100, 3), start = c(1961, 1), frequency = 12)
  mts_tbl <- ts_as_tibble(mts)
  time <- as.double(time(mts))
  testthat::expect_equal(
    mts_tbl,
    dplyr::tibble(
      group = rep(colnames(mts), each = length(time)),
      time = rep(time, ncol(mts)),
      value = as.vector(mts)
    )
  )
  testthat::expect_equal(
    mts_tbl,
    ts_as_tibble.default(mts)
  )
})

testthat::test_that("xts", {
  xts <- structure(c(50.0397819115463, 50.2304961977954, 50.420955209067,
50.3734680543285, 50.2443255196795, 50.1321122972067, 50.0355467742705,
49.9948860954217, 49.9122834457642, 49.8852887132391, 50.2125821224916,
50.3238453485025, 50.4635862266585, 50.6172355897254, 50.620241173435,
50.7414981135498, 50.4805101188755, 50.4138129108681, 50.3532310036568,
50.1618813949374, 50.3600836896748, 50.0396626712588, 50.1095259574076,
50.2073807897632, 50.1600826681477, 50.0604060861532, 49.9658575219043,
49.8562442241656, 49.8547727815966, 50.0704896508826, 50.2244845229791,
50.4450306721515, 50.3721857137319, 50.4818267518265, 50.523893828191,
50.7166067461433, 50.4932188302243, 50.5853098172462, 50.8333117106257,
50.6892288304174, 50.6784905984176, 50.8898983760854, 50.9005579809156,
50.9528277211339, 51.0633014723722, 51.1287929285077, 50.9772173544539,
51.1841370498561, 51.295021248152, 51.1372463340331, 50.9293966227967,
50.7211101780551, 50.843921143575, 50.7835976504561, 50.7896013042288,
50.8816812795241, 50.7433266638814, 50.6943485629562, 50.8162030132845,
50.6097967963997, 50.7324080081653, 50.3927259270933, 50.2650069647869,
50.2746373900041, 50.1445762543741, 49.9314929048729, 49.9237734835486,
49.7936997386099, 49.8306222453665, 49.8276255602479, 49.6962809106445,
49.3626991517068, 49.5737411878039, 49.4489956783527, 49.5566612908277,
49.2977796860981, 49.6274672147247, 49.5952884965034, 49.4976451429029,
49.4230642938896, 49.2728079548362, 48.8663474774338, 48.5064888202386,
48.3421024422286, 48.2524825106404, 48.3309000601732, 48.5923613368859,
48.7456190083389, 48.9561619747141, 48.9440668539277, 48.9048836271181,
49.0607100610899, 49.2257899841075, 49.4143540745659, 49.3362124203641,
49.4517023124334, 49.5433780166351, 49.444289050952, 49.55703548735,
49.7454978974624, 49.7507941077393, 49.7070824171387, 49.7415394908976,
49.7470725636594, 49.7491522227102, 49.846975262063, 49.9379395474831,
50.0244086177575, 49.7604232552535, 49.989541304844, 50.3120333961183,
50.3200947473636, 49.8734026465211, 49.7338525835356, 49.8906358262349,
49.8053048313893, 49.5468840391121, 49.3028935291798, 49.1382464427998,
49.3457214583033, 49.4706167078959, 49.4632789128586, 49.5996297158354,
49.3842789199786, 49.1660587256141, 49.4918780475782, 49.1328177423567,
49.1773905424881, 48.8347914561581, 48.2545634885324, 47.968125028333,
48.0554956281431, 47.644692571948, 47.6064724380648, 47.7206509536914,
47.7942981789561, 47.6501318131713, 47.6555190311968, 47.5621026686154,
47.9658214031213, 47.8183040302612, 47.9359302489862, 47.8904133721512,
47.9823372258737, 48.1452112358212, 48.0101843888937, 47.9014160029841,
47.6566546513431, 47.7886603971671, 47.8284532662533, 47.7443173931521,
47.6022347047868, 47.7121494165901, 47.5151648819698, 47.4109038423752,
47.3658120027045, 47.420985190709, 47.4844872933481, 47.3866882554947,
47.7489862263065, 47.2780696035328, 47.194106912618, 47.4613546517325,
47.4327917992174, 47.3330584316802, 47.3645229105516, 47.2478260931866,
47.4346993610725, 47.4605472647125, 47.7112586675401, 47.7101167781098,
47.5684886049305, 47.2287315871627, 47.2399558001892, 47.2047065698809,
47.4430011919908, 47.6232337843679, 47.6760351295041, 47.6362885503127,
47.6746805308509, 50.1177772350145, 50.421876002125, 50.420955209067,
50.3734680543285, 50.2443255196795, 50.2156114607262, 50.1036323973342,
49.9948860954217, 50.130525854306, 50.239103712694, 50.359801769449,
50.4799955346125, 50.62395479761, 50.6858336400418, 50.7373052873552,
50.7733564529701, 50.6071189691962, 50.5562734759594, 50.3532310036568,
50.4208972428836, 50.4387454378126, 50.1696064309279, 50.2694187981265,
50.2826849790742, 50.1600826681477, 50.0977658473744, 50.0021694838495,
49.930381203448, 50.0218043126519, 50.2257790634706, 50.4137614515346,
50.5348977915646, 50.4691169535685, 50.5550923533772, 50.6978278150252,
50.7166067461433, 50.696932712043, 50.8473366461113, 50.896827622917,
50.726959655694, 50.91776061924, 50.9665340950417, 51.0029854532602,
51.0469861312818, 51.114008680003, 51.1287929285077, 51.1365256784907,
51.3209005779334, 51.323424806756, 51.1494018613584, 50.9293966227967,
50.8659669412615, 50.9694609683283, 50.8645263373624, 50.9318744899078,
50.8816812795241, 50.7890893188517, 50.770905453827, 50.8162030132845,
50.7206096320916, 50.7324080081653, 50.4088124653177, 50.3404988869915,
50.3201916131904, 50.2027764867291, 50.0036413740678, 49.9237734835486,
49.8898404553457, 49.8829457681315, 49.9031130358205, 49.7086250880523,
49.5373488863704, 49.6231039012457, 49.6528522333934, 49.5566612908277,
49.6785736159034, 49.6540715276625, 49.6200349582181, 49.5396073979361,
49.4230642938896, 49.2728079548362, 48.8663474774338, 48.5064888202386,
48.4463705919766, 48.4157189260319, 48.5359461762133, 48.6998847605209,
49.0021812307077, 49.097283039653, 48.9781600566663, 49.0839954270775,
49.245253833598, 49.3733496216003, 49.4143540745659, 49.4189994859189,
49.6095030005936, 49.5896809020894, 49.5023417359146, 49.7877576550563,
49.8192485602815, 49.7546976892052, 49.853322329816, 49.7733970805046,
49.7934102661747, 49.8628865946235, 49.954558677343, 50.0720779787385,
50.0299098586477, 49.9284741862485, 50.2012292399203, 50.337807096784,
50.3200947473636, 49.901838155481, 49.8862227667758, 49.8906358262349,
49.8053048313893, 49.5549664935449, 49.3028935291798, 49.3397448231728,
49.5263478188825, 49.4706167078959, 49.6909716597571, 49.5996297158354,
49.4026580314052, 49.4599885580201, 49.4918780475782, 49.2550693689544,
49.1773905424881, 48.8454913822302, 48.2545634885324, 48.032858055938,
48.0554956281431, 47.7250498159334, 47.7405271861058, 47.9071682801885,
47.7942981789561, 47.7511652769296, 47.7798557548305, 47.9308458230391,
48.029033942613, 47.9482531441853, 48.0824246165765, 48.0307726129326,
48.1754323314596, 48.1452112358212, 48.0216564098931, 47.9339798198289,
47.8934158707544, 47.9326701523078, 47.8404415298449, 47.7443173931521,
47.7454243122342, 47.7121494165901, 47.5354500689903, 47.482170679888,
47.4123313828473, 47.5063692973413, 47.5308912760639, 47.7476950731972,
47.7489862263065, 47.3088378144923, 47.4183383185878, 47.5200446580673,
47.4327917992174, 47.4049049093854, 47.4046284008614, 47.4724863618123,
47.5633569665608, 47.7335250775606, 47.8175924066148, 47.7101167781098,
47.5926598454947, 47.2477128773392, 47.3028651846619, 47.4277219359799,
47.6161097730372, 47.7167299732728, 47.7046027771086, 47.775634540576,
47.9412667206186, 49.9504146442813, 50.2304961977954, 50.2641365663597,
50.2210338242788, 50.1112075487643, 49.9918544993091, 49.9697097184701,
49.8045358090165, 49.9122834457642, 49.8852887132391, 50.1717574121646,
50.3238453485025, 50.4635862266585, 50.4735909825374, 50.5662652106609,
50.449321357316, 50.4026921292911, 50.4127813388677, 50.0214153820363,
50.1604405513317, 50.2112913039383, 50.0366991631639, 50.063868338926,
50.1291318545355, 49.9405191078187, 49.9726670534334, 49.8746804186122,
49.7630844122028, 49.7724223081099, 50.0704896508826, 50.191012164208,
50.3606408837506, 50.298799757062, 50.4020264816621, 50.459767560449,
50.4986480384182, 50.4932188302243, 50.5853098172462, 50.6768581674052,
50.6070733856372, 50.6784905984176, 50.8360446014901, 50.8793493835529,
50.803171907551, 50.9468108768572, 51.0061335218936, 50.952600190595,
51.1371299879095, 51.1352419149073, 50.9352261443787, 50.6987973947919,
50.6571814189883, 50.7305961336348, 50.7669213141213, 50.7896013042288,
50.7548084168209, 50.6187434734297, 50.5988137418271, 50.5645087290095,
50.5080789844205, 50.4092945808094, 50.2492157707179, 50.2650069647869,
50.1638044184635, 49.9138089296028, 49.8489346112531, 49.7424150559387,
49.7038514071734, 49.760310812525, 49.670494239676, 49.3792415099661,
49.3074568226063, 49.3987553413956, 49.4241619504068, 49.3356413900106,
49.2977796860981, 49.5160420086702, 49.4232068118256, 49.4160965263844,
49.3118358542017, 48.9309517223527, 48.5268371665895, 48.3340927379523,
48.2896926777253, 48.2364771063669, 48.3309000601732, 48.5743179732927,
48.7456190083389, 48.9561619747141, 48.8096186482138, 48.9048836271181,
48.9692750768163, 49.1991258503583, 49.3064111174296, 49.3362124203641,
49.4517023124334, 49.4180628219513, 49.3382782378181, 49.55703548735,
49.7454978974624, 49.6173171733521, 49.6924492458175, 49.7015885221842,
49.662988150532, 49.7109114979342, 49.7775439894587, 49.9248422973257,
49.8394501870147, 49.6980794321414, 49.989541304844, 50.2478765013235,
49.8757386019976, 49.7276899923422, 49.7338525835356, 49.7489871076424,
49.5081397146114, 49.2918633073164, 49.0567561810582, 49.1149971640139,
49.3457214583033, 49.3426131232972, 49.4632789128586, 49.4137530585047,
49.1031043568417, 49.1660587256141, 49.1357230365042, 49.1328177423567,
48.7270762056073, 48.3800124679673, 47.9690434191124, 47.8926179087975,
47.6620855703505, 47.5821240912087, 47.5179560866739, 47.7091322313329,
47.5513987007966, 47.6501318131713, 47.6053615081546, 47.5621026686154,
47.7807235394881, 47.811546625574, 47.8876326500158, 47.8841269246251,
47.9450716031323, 47.9264941691766, 47.9019342884565, 47.6471764517754,
47.6544603143575, 47.7886603971671, 47.7377986168352, 47.5482040904643,
47.5679622276754, 47.501976670636, 47.3234230750255, 47.211163022771,
47.2330580059869, 47.3532002325846, 47.4281355831578, 47.3866882554947,
47.2868487885989, 47.1466018260288, 47.1815348543221, 47.4308266385453,
47.3348965212827, 47.2615736095983, 47.2605645709109, 47.2478260931866,
47.3642401566334, 47.4605472647125, 47.668434910213, 47.6110642732936,
47.3254940958526, 47.0914419882576, 47.2093194619751, 47.1340495076106,
47.4430011919908, 47.6001511393257, 47.5724060421453, 47.6173290583887,
47.6746805308509, 50.1177772350145, 50.3976663383861, 50.3323571013133,
50.3345948961691, 50.1811210391819, 49.9918544993091, 49.988063256042,
49.913329335608, 49.9724600550638, 50.239103712694, 50.2851940807548,
50.4128602347002, 50.6014452374366, 50.4891214813319, 50.6783465243683,
50.4864408302735, 50.5763196086684, 50.4127813388677, 50.0214153820363,
50.4208972428836, 50.2112913039383, 50.1696064309279, 50.2314483010655,
50.2433369933702, 50.070242540723, 50.0109145160256, 49.8809633637625,
49.9187495029809, 50.0218043126519, 50.2257790634706, 50.3578435161537,
50.3692756978625, 50.4310899203875, 50.5550923533772, 50.6978278150252,
50.4986480384182, 50.6061055576287, 50.8138255864256, 50.6768581674052,
50.695622055169, 50.9115985194411, 50.9665340950417, 50.9010550008819,
51.0469861312818, 51.0518465248395, 51.0216357806733, 51.1365256784907,
51.1515142172957, 51.1789930735369, 50.9352261443787, 50.7732543242554,
50.8659669412615, 50.7649826990875, 50.7953382903315, 50.8477621406292,
50.7548084168209, 50.6920604718023, 50.770905453827, 50.570749692632,
50.6155918666066, 50.4103286523541, 50.3263588179421, 50.2956702271079,
50.1638044184635, 49.9138089296028, 49.9183871340213, 49.8071204530403,
49.8869833529875, 49.78805814558, 49.7403315550003, 49.3792415099661,
49.5373488863704, 49.496003986535, 49.5950011884777, 49.3471431527284,
49.6546261076859, 49.5458954022922, 49.5068963631111, 49.5180739210179,
49.3968738599656, 48.9309517223527, 48.5268371665895, 48.3397338277091,
48.2896926777253, 48.30850892202, 48.5359461762133, 48.6998847605209,
48.9354567345693, 48.974901416968, 48.8703195118646, 49.0631647734845,
49.245253833598, 49.3473606787059, 49.3377557822211, 49.4189994859189,
49.5381883056603, 49.4180628219513, 49.5023417359146, 49.7698448660165,
49.7462345946245, 49.7299649322951, 49.7333931653161, 49.7555215783115,
49.7094151808194, 49.8388590726778, 49.954558677343, 50.0720779787385,
49.8394501870147, 49.9110274504956, 50.2012292399203, 50.3255614801967,
49.8853882678616, 49.7276899923422, 49.8847151942606, 49.7920112943787,
49.5081397146114, 49.2918633073164, 49.1352904471748, 49.3397448231728,
49.4713813499697, 49.3852052435403, 49.5867696788652, 49.4137530585047,
49.1031043568417, 49.4599885580201, 49.1357230365042, 49.1893012571989,
48.7270762056073, 48.3800124679673, 47.9690434191124, 48.0193547288843,
47.6620855703505, 47.6592988835332, 47.726862406458, 47.8668317346629,
47.6293786041021, 47.6842280532209, 47.6053615081546, 47.9308458230391,
47.7807235394881, 47.8294556467246, 47.9006826430557, 48.0113049442773,
48.1605755467172, 47.9961340046721, 47.9019342884565, 47.6471764517754,
47.8725213360129, 47.8329083126244, 47.7377986168352, 47.6512305894323,
47.7256907018078, 47.501976670636, 47.3764237289667, 47.2292952802724,
47.4004820908595, 47.4526174659862, 47.4835950385865, 47.7476950731972,
47.2868487885989, 47.1466018260288, 47.4183383185878, 47.4308266385453,
47.3488381779215, 47.3677901566039, 47.2605645709109, 47.3952135245457,
47.3642401566334, 47.6722018616947, 47.668434910213, 47.6292144787367,
47.3254940958526, 47.2477128773392, 47.2276437542817, 47.4277219359799,
47.6161097730372, 47.6276905335225, 47.6071583256498, 47.6647123051268,
47.7671937777376), dim = c(180L, 4L), dimnames = list(NULL, c("Open",
"High", "Low", "Close")), index = structure(c(1167696000, 1167782400,
1167868800, 1167955200, 1168041600, 1168128000, 1168214400, 1168300800,
1168387200, 1168473600, 1168560000, 1168646400, 1168732800, 1168819200,
1168905600, 1168992000, 1169078400, 1169164800, 1169251200, 1169337600,
1169424000, 1169510400, 1169596800, 1169683200, 1169769600, 1169856000,
1169942400, 1170028800, 1170115200, 1170201600, 1170288000, 1170374400,
1170460800, 1170547200, 1170633600, 1170720000, 1170806400, 1170892800,
1170979200, 1171065600, 1171152000, 1171238400, 1171324800, 1171411200,
1171497600, 1171584000, 1171670400, 1171756800, 1171843200, 1171929600,
1172016000, 1172102400, 1172188800, 1172275200, 1172361600, 1172448000,
1172534400, 1172620800, 1172707200, 1172793600, 1172880000, 1172966400,
1173052800, 1173139200, 1173225600, 1173312000, 1173398400, 1173484800,
1173571200, 1173657600, 1173744000, 1173830400, 1173916800, 1174003200,
1174089600, 1174176000, 1174262400, 1174348800, 1174435200, 1174521600,
1174608000, 1174694400, 1174780800, 1174863600, 1174950000, 1175036400,
1175122800, 1175209200, 1175295600, 1175382000, 1175468400, 1175554800,
1175641200, 1175727600, 1175814000, 1175900400, 1175986800, 1176073200,
1176159600, 1176246000, 1176332400, 1176418800, 1176505200, 1176591600,
1176678000, 1176764400, 1176850800, 1176937200, 1177023600, 1177110000,
1177196400, 1177282800, 1177369200, 1177455600, 1177542000, 1177628400,
1177714800, 1177801200, 1177887600, 1177974000, 1178060400, 1178146800,
1178233200, 1178319600, 1178406000, 1178492400, 1178578800, 1178665200,
1178751600, 1178838000, 1178924400, 1179010800, 1179097200, 1179183600,
1179270000, 1179356400, 1179442800, 1179529200, 1179615600, 1179702000,
1179788400, 1179874800, 1179961200, 1180047600, 1180134000, 1180220400,
1180306800, 1180393200, 1180479600, 1180566000, 1180652400, 1180738800,
1180825200, 1180911600, 1180998000, 1181084400, 1181170800, 1181257200,
1181343600, 1181430000, 1181516400, 1181602800, 1181689200, 1181775600,
1181862000, 1181948400, 1182034800, 1182121200, 1182207600, 1182294000,
1182380400, 1182466800, 1182553200, 1182639600, 1182726000, 1182812400,
1182898800, 1182985200, 1183071600, 1183158000), tzone = "", tclass = c("POSIXct",
"POSIXt")), class = c("xts", "zoo"))
  # Load methods without using library() or loadNamespace()
  zoo::yearmon
  # The below should work if we have zoo loaded but not xts..
  xts_tbl <- ts_as_tibble(xts)
  time <- lubridate::as_datetime(attr(xts, "index"),
                                 tz = attr(attr(xts, "index"), "tzone"))
  testthat::expect_equal(
    xts_tbl,
    dplyr::tibble(
      group = rep(colnames(xts), each = length(time)),
      time = rep(time, ncol(xts)),
      value = as.vector(xts)
    )
  )
  xts_tbl2 <- ts_as_tibble.default(xts)
  xts_tbl$time <- as.double(xts_tbl$time)
  testthat::expect_equal(
    xts_tbl, xts_tbl2
  )
})

testthat::test_that("zoo", {
  # Load methods without using library() or loadNamespace()
  zoo::yearmon
  # Example 1 - Univariate (no col names)
  x.Date <- as.Date("2003-02-01") + c(1, 3, 7, 9, 14) - 1
  x <- structure(c(0.807268292139951, 0.757088653227813, 0.239998755408692,
                   0.549973058300116, 1.73072914807555), index = structure(c(12084,
                                                                             12086, 12090, 12092, 12097), class = "Date"), class = "zoo")
  zoo_tbl <- ts_as_tibble(x)
  time <- x.Date
  testthat::expect_equal(
    zoo_tbl,
    dplyr::tibble(
      time = time,
      value = as.vector(x)
    )
  )
  zoo_tbl2 <- ts_as_tibble.default(x)
  zoo_tbl$time <- as.double(zoo_tbl$time)
  testthat::expect_equal(
    zoo_tbl, zoo_tbl2
  )
  # Example 2 - Multivariate (no col names)
  x <- structure(1:12, dim = 4:3, index = structure(c(12053, 12054,
                                                      12055, 12056), class = "Date"), class = "zoo")
  zoo_tbl <- ts_as_tibble(x)
  time <- .Date(c(12053, 12054, 12055, 12056))
  # index_origin <- min(time) - 1
  testthat::expect_equal(
    zoo_tbl,
    dplyr::tibble(
      group = rep(seq_len(ncol(x)), each = length(time)),
      time = rep(time, ncol(x)),
      value = as.vector(x)
    )
  )
  zoo_tbl2 <- ts_as_tibble.default(x)
  zoo_tbl$time <- as.double(zoo_tbl$time)
  testthat::expect_equal(
    zoo_tbl, zoo_tbl2
  )
  # Example 3 - Empty zoo object
  x <- structure(logical(0), dim = c(4L, 0L), index = 1:4, class = "zoo")
  zoo_tbl <- ts_as_tibble(x)
  time <- time(x)
  testthat::expect_equal(
    zoo_tbl,
    dplyr::tibble(
      group = rep(seq_len(ncol(x)), each = length(time)),
      time = rep(time, ncol(x)),
      value = as.vector(x)
    )
  )
  zoo_tbl2 <- ts_as_tibble.default(x)
  zoo_tbl$time <- as.double(zoo_tbl$time)
  testthat::expect_equal(
    zoo_tbl, zoo_tbl2
  )
  # Example 4 - Multivariate (with col names)
  x <- structure(c(1.07322426812411, 0.880290672187144, 1.33868814497599,
                   -0.426495878391455, 0.473718067974476, -0.527341305539617, 0.153018950466085,
                   0.693596285898734, -0.652664476797938, -1.33175669450864, 0.804711335174417,
                   0.0810663365096519, -0.254590513887369, -3.15044468805853, -0.892743376227607
  ), dim = c(5L, 3L), dimnames = list(NULL, c("foo", "bar", "yeah"
  )), index = structure(c(0, 10800, 21600, 32400, 43200), class = c("POSIXct",
                                                                         "POSIXt"), tzone = "UTC"), class = "zoo")
  zoo_tbl <- ts_as_tibble(x)
  time <- .POSIXct(c(0, 10800, 21600, 32400, 43200), tz = "UTC")
  testthat::expect_equal(
    zoo_tbl,
    dplyr::tibble(
      group = rep(colnames(x), each = length(time)),
      time = rep(time, ncol(x)),
      value = as.vector(x)
    )
  )
  zoo_tbl2 <- ts_as_tibble.default(x)
  zoo_tbl$time <- as.double(zoo_tbl$time)
  testthat::expect_equal(
    zoo_tbl, zoo_tbl2
  )
})

# testthat::test_that("timeSeries", {
#   x <- methods::new("timeSeries", .Data = structure(c(63.4375, 60.8125, 61, 60.5,
#                                                       59.5625, 56.375, 55.5, 55.8125, 55.625, 53.9375, 63.5625, 61.875,
#                                                       61.3125, 60.8125, 59.8125, 56.5625, 57.25, 56.75, 55.75, 55.5625,
#                                                       59.8125, 60.625, 58.625, 58.25, 56.5, 54.5, 55.25, 54.75, 53,
#                                                       53.8125, 60.625, 61.3125, 60.3125, 59.125, 56.5625, 55.4375,
#                                                       55.375, 55.5625, 54.1875, 54.5625, 53077800, 26180200, 37026800,
#                                                       29281200, 42687000, 68226700, 40549700, 30897000, 29161800, 31033100
#   ), dim = c(10L, 5L), dimnames = list(NULL, c("Open", "High",
#                                                "Low", "Close", "Volume"))), units = c("Open", "High", "Low",
#                                                                                       "Close", "Volume"), positions = c(970012800, 970099200, 970185600,
#                                                                                                                         970444800, 970531200, 970617600, 970704000, 970790400, 971049600,
#                                                                                                                         971136000), format = "%Y-%m-%d", FinCenter = "GMT", recordIDs = structure(list(), names = character(0), row.names = integer(0), class = "data.frame"),
#   title = "Time Series Object", documentation = "")
#   ts_tbl <- ts_as_tibble(x)
#   time <- lubridate::as_datetime(attr(unclass(x), "positions"))
#   testthat::expect_equal(
#     ts_tbl,
#     dplyr::tibble(
#       group = rep(colnames(x), each = length(time)),
#       time = rep(time, ncol(x)),
#       value = as.vector(x)
#     )
#   )
# })
