% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc.R
\name{asc}
\alias{asc}
\alias{desc}
\title{Helpers to sort variables in ascending or descending order}
\usage{
asc(x)

desc(x)
}
\arguments{
\item{x}{Vector.}
}
\value{
A numeric vector that can be ordered in ascending or descending order. \cr
Useful in \code{dplyr::arrange()} or \code{farrange()}.
}
\description{
An alternative to \code{dplyr::desc()} which is much faster
for character vectors and factors.
}
\examples{
library(dplyr)
library(timeplyr)
library(nycflights13)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
flights \%>\%
  fdistinct(dest) \%>\%
  farrange(desc(dest))
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
