% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_roll_diff.R
\name{time_roll_diff}
\alias{time_roll_diff}
\title{Lagged time differences}
\usage{
time_roll_diff(
  time,
  time_by = 1,
  lag = 1L,
  g = NULL,
  time_type = c("auto", "duration", "period")
)
}
\arguments{
\item{time}{Time variable. \cr
Can be a \code{Date}, \code{POSIXt}, \code{numeric}, \code{integer}, \code{yearmon}, or \code{yearqtr}.}

\item{time_by}{Time unit. \cr
Must be one of the following:
\itemize{
\item string, specifying either the unit or the number and unit, e.g
\code{time_by = "days"} or \code{time_by = "2 weeks"}
\item named list of length one, the unit being the name, and
the number the value of the list, e.g. \code{list("days" = 7)}.
For the vectorized time functions, you can supply multiple values,
e.g. \code{list("days" = 1:10)}.
\item Numeric vector. If time_by is a numeric vector and x is not a date/datetime,
then arithmetic is used, e.g \code{time_by = 1}.
}}

\item{lag}{A number indicating the lag size. Negative values are allowed.}

\item{g}{Grouping object passed directly to \code{collapse::GRP()}.
This can for example be a vector or data frame.}

\item{time_type}{If "auto", \code{periods} are used for
the time expansion when days, weeks, months or years are specified,
and \code{durations} are used otherwise.}
}
\value{
A numeric vector the same length as \code{x.}
on the arguments supplied.
}
\description{
\code{time_roll_diff} is like \code{diff()} but always returns a \code{numeric(length(x))}.
}
\details{
\code{time_elapsed} is very similar to \code{time_roll_diff} but
is more general in that it supports
cumulative time differencing, \code{NA} filling as well as \code{NA} skipping.
}
\seealso{
\link{time_elapsed}
}
