% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence2.R
\name{sequence2}
\alias{sequence2}
\alias{seq_id}
\alias{seq_v}
\title{Extension to \code{base::sequence()}}
\usage{
sequence2(nvec, from = 1L, by = 1L)

seq_id(nvec)

seq_v(from = 1L, to = 1L, by = 1L)
}
\arguments{
\item{nvec}{Vector of sequence lengths.}

\item{from}{Start of sequence(s).}

\item{by}{Unit increment of sequence(s).}

\item{to}{End of sequence(s).}
}
\value{
\code{sequence2} and \code{seq_id} return a vector \code{length(sum(nvec))}. \cr
\code{seq_v} returns a vector of size \code{sum((to - from) / (by + 1))}
}
\description{
Like \code{sequence()} but it accepts decimal increments.
}
\details{
\code{sequence2()} works in the same as \code{sequence()} but can accept
non-whole number \code{by} values.
It also doesn't recycle \code{from} and \code{to}, in the same as \code{sequence()}. \cr
If any of the sequences contain integers > .Machine$integer.max,
then the result will always be a double vector.

\code{seq_v()} is a vectorised version of \code{seq()} that strictly accepts
only the arguments \code{from}, \code{to} and \code{by}. \cr
\code{seq_id()} is a helper function to efficiently return unique IDs for
each sequence.
}
\examples{
library(timeplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
sequence(1:3)
sequence2(1:3)

sequence(1:3, by = 0.1)
sequence2(1:3, by = 0.1)

sequence(c(3, 2), by = c(-0.1, 0.1))
sequence2(c(3, 2), by = c(-0.1, 0.1))
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
