
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General
# Public License along with this library; if not, write to the
# Free Foundation, Inc., 59 Temple Place, Suite 330, Boston,
# MA  02111-1307  USA

# Copyrights (C)
# for this R-port:
#   2007, Yohan Chalabi, GPL
#   Yohan Chalabi <ychalabi@phys.ethz.ch>
#   1999 - 2007, Diethelm Wuertz, GPL
#   Diethelm Wuertz <wuertz@itp.phys.ethz.ch>
#   info@rmetrics.org
#   www.rmetrics.org
# for the code accessed (or partly included) from other R-ports:
#   see R's copyright and license files
# for the code accessed (or partly included) from contributed R-ports
# and other sources
#   see Rmetrics's copyright file


################################################################################
# FUNCTION:                 DESCRIPOTION:
#  .genDaylightSavingTime   Create file with Daylight Saving Time Rules for all
#                           centers in listFinCenter()
################################################################################
# The following DST Rules were extracted from tzdata (version tzdata2008e)
# and integrated into R functions.


.genDaylightSavingTime <-
    function(filename = "DaylightSavingTime.R")
{
    cat(
        "\t this function generates DST rules from the output
\t of the command line \"zdump\" on a _linux_ box.\n")

    finCenter <- listFinCenter()

    # create source file
    cat("
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General
# Public License along with this library; if not, write to the
# Free Foundation, Inc., 59 Temple Place, Suite 330, Boston,
# MA  02111-1307  USA

# Copyrights (C)
# for this R-port:
#   2007-2008, Yohan Chalabi, GPL
#   Yohan Chalabi <ychalabi@phys.ethz.ch>
#   1999 - 2007, Diethelm Wuertz, GPL
#   Diethelm Wuertz <wuertz@itp.phys.ethz.ch>
#   info@rmetrics.org
#   www.rmetrics.org
# for the code accessed (or partly included) from other R-ports:
#   see R's copyright and license files
# for the code accessed (or partly included) from contributed R-ports
# and other sources
#   see Rmetrics's copyright file


# fCalendar::2A-DaylightSavingTime.R
################################################################################
# FUNCTION:                 DESCRIPOTION:
#  Algiers                   Returns Algiers Daylight Saving Time Rules
#  ...
#  Honolulu                  Returns Honolulu Daylight Saving Time Rules
################################################################################


################################################################################
# The following DST Rules were extracted from tzdata (version tzdata2007k)
# and integrated into R functions.
################################################################################
# This file was auto-generated by .genDaylightSavingTime()
#


",file = filename)

    for (k in seq(length(finCenter))) {

        # run zdump linux command
        zdump <- try(system(paste("zdump -v", finCenter[k], sep=" "), intern=TRUE))
        zdump <- strsplit(zdump, " +" )
        zdump <- matrix(unlist(zdump), nrow = length(zdump), byrow = TRUE)

        # extract data
        fccity <-  strsplit(finCenter, "/")[[k]]
        tms <- zdump[,5]
        dts <-  as.Date(paste(zdump[,3], zdump[,4], zdump[,6]),
                        format="%b %d %Y")
        tzs <- zdump[,14]
        isdst <- as.integer(substr(zdump[,15],7,8))
        # important to use nchar(zdump[,16] because length of gmtoff is variable
        gmtoff <- as.integer(substr(zdump[,16],8,nchar(zdump[,16])))

###         # Determine the index of row which are relevant for DST rules
###         if (sum(isdst)==0) { ## when there is no DST rules for a given TZ
###             currentYear <- format(Sys.Date(), "%Y")
###             yearDTS <- format(dts, "%Y")
###             index <- length(yearDTS[yearDTS <= currentYear])
###         } else {
###             x <- isdst[1]
###             index <- NULL
###             j <- 1
###             for (i in seq(length(isdst))) {
###                 if (x != isdst[i]) {
###                     index[j] <- i-2
###                     x <- isdst[i]
###                     j <- j+1
###                 }
###             }
###         }

        # Determine the index of row which are relevant for offset/gmtoff rules
        test <- gmtoff - rep(gmtoff[1],length(gmtoff))
        if (sum(test)==0) { ## when there is no DST rules for a given TZ
            currentYear <- format(Sys.Date(), "%Y")
            yearDTS <- format(dts, "%Y")
            index <- length(yearDTS[yearDTS <= currentYear])
        } else {
            x <- gmtoff[1]
            index <- NULL
            j <- 1
            for (i in seq(length(gmtoff))) {
                if (x != gmtoff[i]) {
                    index[j] <- i-2
                    x <- gmtoff[i]
                    j <- j+1
                }
            }
            # YC: add last entry; important for short DST table like
            # Tokyo(), Singapore, ... !
            index[length(index) + 1] <- index[length(index)] + 2
        }

        # construct table rule for the given fin center
        dst <- data.frame(cbind(paste(dts[index],
                                      tms[index]),
                                gmtoff[index],
                                isdst[index],
                                tzs[index]),
                          stringsAsFactors = FALSE)
        colnames(dst) <- c(fccity[length(fccity)],
                           "offSet",
                           "isdst",
                           "TimeZone")

        # add function to file DST.R if table exits
        if (nrow(dst) != 0) {
            dstFile <- file(filename, open = "a")
            cat("\"", fccity[length(fccity)], "\"", " <- function () {\n",
                sep ="", file = dstFile)
            dput(dst, file = dstFile)
            cat("}\n\n", file = dstFile)
            close(dstFile)
        }
        else {
            cat("Error : Emtpy table for", finCenter[k], "\n")
        }
    }

    cat("
## this is for compatibility purpose with previous version
BuenosAires <- Buenos_Aires
LosAngeles <- Los_Angeles
MexicoCity <- Mexico_City
NewYork <- New_York
Eastern <- New_York
HongKong <- Hong_Kong
KualaLumpur <- Kuala_Lumpur
Frankfurt <- Berlin
Pacific <- LosAngeles
",
        file = filename, append = TRUE)
}

## ### source http://www.stacken.kth.se/~kvickers/timezone.html
## ###
## ###   Zone                            Offset   Where
## ###   ----                            ------   ------
## ###    EET     Eastern European        +2      Finland, Eastern Europe
## ###    CET     Central European        +1      Western Europe, Sweden
## ###    GMT     Greenwich Mean          none    United Kingdom, Portugal
## ###    AST     Atlantic Standard       -4      Halifax
## ###    EST     Eastern Standard        -5      NY, DC, Toronto, Montreal
## ###    CST     Central Standard        -6      Chicago, Houston, Winnipeg
## ###    MST     Mountain Standard       -7      Denver, Calgary, Edmonton
## ###    PST     Pacific Standard        -8      LA, San Fransisco, Vancouver

## ## have it automatic

## EET <- function()
##     data.frame(EET = "1902-01-01 00:00:00",
##                offSet = 2 * 3600,
##                isdst = 0,
##                TimeZone = "EET",
##                stringsAsFactors = FALSE)

## CET <- function()
##     data.frame(CET = "1902-01-01 00:00:00",
##                offSet = 1 * 3600,
##                isdst = 0,
##                TimeZone = "CET",
##                stringsAsFactors = FALSE)

## AST <- function()
##     data.frame(AST = "1902-01-01 00:00:00",
##                offSet = -4 * 3600,
##                isdst = 0,
##                TimeZone = "AST",
##                stringsAsFactors = FALSE)

## EST <- function()
##     data.frame(EST = "1902-01-01 00:00:00",
##                offSet = -5 * 3600,
##                isdst = 0,
##                TimeZone = "EST",
##                stringsAsFactors = FALSE)

## CST <- function()
##     data.frame(CST = "1902-01-01 00:00:00",
##                offSet = -6 * 3600,
##                isdst = 0,
##                TimeZone = "CST",
##                stringsAsFactors = FALSE)

## MST <- function()
##     data.frame(MST = "1902-01-01 00:00:00",
##                offSet = -7 * 3600,
##                isdst = 0,
##                TimeZone = "MST",
##                stringsAsFactors = FALSE)

## PST <- function()
##     data.frame(PST = "1902-01-01 00:00:00",
##                offSet = -8 * 3600,
##                isdst = 0,
##                TimeZone = "PST",
##                stringsAsFactors = FALSE)
