% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFrame.R
\name{fromDataFrame}
\alias{fromDataFrame}
\title{Create a TileDB dense or sparse array from a given \code{data.frame} Object}
\usage{
fromDataFrame(
  obj,
  uri,
  col_index = NULL,
  sparse = FALSE,
  allows_dups = sparse,
  cell_order = "ROW_MAJOR",
  tile_order = "ROW_MAJOR",
  filter = "ZSTD",
  capacity = 10000L,
  tile_domain = NULL,
  tile_extent = NULL,
  debug = FALSE
)
}
\arguments{
\item{obj}{A \code{data.frame} object.}

\item{uri}{A character variable with an Array URI.}

\item{col_index}{An optional column index, either numeric with a column index,
or character with a column name, designating an index column; default is NULL
implying an index column is added when the array is created}

\item{sparse}{A logical switch to select sparse or dense (the default)}

\item{allows_dups}{A logical switch to select if duplicate values
are allowed or not, default is the same value as \sQuote{sparse}.}

\item{cell_order}{A character variable with one of the TileDB cell order values,
default is \dQuote{COL_MAJOR}.}

\item{tile_order}{A character variable with one of the TileDB tile order values,
default is \dQuote{COL_MAJOR}.}

\item{filter}{A character variable vector, defaults to \sQuote{ZSTD}, for
one or more filters to be applied to each attribute;}

\item{capacity}{A integer value with the schema capacity, default is 10000.}

\item{tile_domain}{An integer vector of size two specifying the integer domain of the row
dimension; if \code{NULL} the row dimension of the \code{obj} is used.}

\item{tile_extent}{An integer value for the tile extent of the row dimensions;
if \code{NULL} the row dimension of the \code{obj} is used. Note that the \code{tile_extent}
cannot exceed the tile domain.}

\item{debug}{Logical flag to select additional output}
}
\value{
Null, invisibly.
}
\description{
The supplied \code{data.frame} object is (currently) limited to integer,
numeric, or character. In addition, three datetime columns are supported
with the R representations of \code{Date}, \code{POSIXct} and \code{nanotime}.
}
\details{
The created (dense or sparse) array will have as many attributes as there
are columns in the \code{data.frame}.  Each attribute will be a single column.
For a sparse array, one or more columns have to be designated as dimensions.

At present, factor variable are converted to character.
}
\examples{
\dontshow{ctx <- tiledb_ctx(limitTileDBCores())}
\dontrun{
uri <- tempfile()
## turn factor into character
irisdf <- within(iris, Species <- as.character(Species))
fromDataFrame(irisdf, uri)
arr <- tiledb_array(uri, as.data.frame=TRUE, sparse=FALSE)
newdf <- arr[]
all.equal(iris, newdf)
}
}
