% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArraySchema.R
\name{tiledb_array_schema_set_enumeration_empty}
\alias{tiledb_array_schema_set_enumeration_empty}
\title{Add an empty Enumeration to a Schema}
\usage{
tiledb_array_schema_set_enumeration_empty(
  schema,
  attr,
  enum_name,
  type_str = "ASCII",
  cell_val_num = NA_integer_,
  ordered = FALSE,
  ctx = tiledb_get_context()
)
}
\arguments{
\item{schema}{An Array Schema}

\item{attr}{An Attribute for which an empty Enumeration will be added}

\item{enum_name}{A character value with the Enumeration name}

\item{type_str}{A character value with the TileDB type, defaults to \sQuote{ASCII}}

\item{cell_val_num}{An integer with number values per cell, defaults to \code{NA_integer_} to
flag the \code{NA} value use for character values}

\item{ordered}{A logical value indicated standard \code{factor} (when \code{FALSE}, the default)
or \code{ordered} (when \code{TRUE})}

\item{ctx}{Optional tiledb_ctx object}
}
\description{
Add an empty Enumeration to a Schema
}
