% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metro_areas.R
\name{combined_statistical_areas}
\alias{combined_statistical_areas}
\title{Download a combined statistical areas shapefile into R}
\usage{
combined_statistical_areas(cb = FALSE, resolution = "500k", year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{resolution}{The resolution of the cartographic boundary file (if cb == TRUE).
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year (defaults to 2018).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sp"} (the default) or \code{"sf"} to
request sp or sf class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
Combined statistical areas are "two or more adjacent CBSAs that have significant
employment interchanges."  In turn, CSAs are composed of multiple metropolitan and/or micropolitan areas, and should
not be compared with individual core-based statistical areas.
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2018/TGRSHP2018_TechDoc.pdf}

Other metro area functions: 
\code{\link{core_based_statistical_areas}()},
\code{\link{metro_divisions}()},
\code{\link{new_england}()},
\code{\link{urban_areas}()}
}
\concept{metro area functions}
