% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water.R
\name{area_water}
\alias{area_water}
\title{Download an area water shapefile into R}
\usage{
area_water(state, county, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code of the state of the county you'd like to
download the water features for.  Can also be state name or abbreviation
(case-insensitive).}

\item{county}{The three-digit FIPS code of the county you'd like the water
features for.  Can also be a county name.}

\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
From the US Census Bureau: "The area hydrography shapefile contains the geometry
and attributes of both perennial and intermittent
area hydrography features, including ponds, lakes, oceans, swamps, glaciers, and the area covered by
large streams represented as double-line drainage."
}
\examples{
\dontrun{
library(tigris)
library(sp)

dallas_water <- area_water("TX", "Dallas")

plot(dallas_water)

}
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2015/TGRSHP2015_TechDoc.pdf}

Other water functions: \code{\link{coastline}},
  \code{\link{linear_water}}
}
