% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/national.R
\name{divisions}
\alias{divisions}
\title{Download a US Census divisions cartographic boundary shapefile into R}
\usage{
divisions(resolution = "500k")
}
\arguments{
\item{resolution}{The resolution of the cartographic boundary file.
       Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}
}
\description{
Download a US Census divisions cartographic boundary shapefile into R
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

divs <- divisions(resolution = '20m')

leaflet(divs) \%>\%
   addTiles() \%>\%
   addPolygons()
}
}
\seealso{
Other national cartographic boundary functions: \code{\link{nation}};
  \code{\link{regions}}
}

